<?php ob_start("em_theme_minified"); ?>
<!DOCTYPE html>
<html lang="en-US">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="robots" content="<?= $set_robot; ?>, max-image-preview:large" />
  <?php if($set_type == 'index'): ?>
    <title><?= em_config('site.name'); ?> - <?= em_config('site.slog'); ?></title>
  <?php else: ?>
    <title><?= $set_title ?> - <?= em_config('site.name'); ?></title>
  <?php endif; ?>
  <meta name="description" content="<?= em_config('site.desc'); ?>" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" sizes="32x32" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" sizes="192x192" />
  <link rel="apple-touch-icon" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <meta name="msapplication-TileImage" content="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <link rel="stylesheet" href="<?= em_asset_url('font/'.em_config('style.font').'.css?v=1.0.0'); ?>" />
  <link rel="stylesheet" href="<?= em_asset_url('css/em_style.css?v='.em_script_ver()); ?>" />
  <script type="text/javascript" src="<?= em_asset_url('js/em_bundle.js?v=3.7.1'); ?>"></script>
  <style type="text/css"><?= em_custom_css(); ?></style>
</head>
<body em-theme="dark" em-page="<?= $set_type; ?>" em-base="<?= em_site_url(); ?>" em-pers="<?= em_user()->user_login() ? 'user' : 'guest'; ?>" id="emerel-cms"><ppbreak/>
<div class="em_root">
  <?php if($set_type !== 'index' && $set_type !== 'P404P'): ?>
  <div class="em_head">
    <div class="h_brand">
      <a href="<?= em_user()->user_login() ? em_site_url('dash/') : em_site_url(); ?>" title="<?= em_config('site.name'); ?>">
        <img src="<?= em_asset_url('img/brand/'.em_config('site.logo')); ?>" width="160" height="53" title="<?= em_config('site.name'); ?>">
      </a>
      <div class="hb_mob_menu"><i class="fa-solid fa-bars-staggered"></i></div>
    </div>
    <div class="h_menu">
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/'); ?>" hm-page="dash" title="Dashboard"><i class="fa-solid fa-gauge"></i><span>Dashboard</span></a></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/mining/'); ?>" hm-page="mining" title="Your Mining"><i class="fa-solid fa-microchip"></i><span>Your Mining</span></a></div>
      <div class="hm_group"><span>Financial History</span></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/user/earnings/'); ?>" hm-page="earnings" title="Earnings"><i class="fa-solid fa-rectangle-list"></i><span>Earnings</span></a></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/user/deposits/'); ?>" hm-page="deposits" title="Deposits"><i class="fa-solid fa-cash-register"></i><span>Deposits</span></a></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/user/withdrawals/'); ?>" hm-page="withdrawals" title="Withdrawals"><i class="fa-solid fa-wallet"></i><span>Withdrawals</span></a></div>
      <div class="hm_group"><span>Account</span></div>
      <?php if((int)em_this_user('usr_admin') === 15): ?><div class="hm_item"><a class="hmi_link" href="<?= em_admin_url(); ?>" hm-page="admin" title="Admin Panel"><i class="fa-solid fa-user-shield"></i><span>Admin Panel</span></a></div><?php endif; ?>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('dash/user/settings/'); ?>" hm-page="settings" title="Settings"><i class="fa-solid fa-gears"></i><span>Settings</span></a></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url(); ?>" hm-page="homepage" title="Homepage"><i class="fa-solid fa-house"></i><span>Homepage</span></a></div>
      <div class="hm_item"><a class="hmi_link" href="<?= em_site_url('logout/'); ?>" title="Logout"><i class="fa-solid fa-right-from-bracket"></i><span>Logout</span></a></div>
    </div>
  </div>
  <div class="em_main">
    <?php if(em_config('layout.ads.status')): ?>
    <div class="em_ads"><div class="ema_cont"><?= em_config('layout.ads.code'); ?></div></div>
    <?php endif; ?>
  <?php endif; ?>
