<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Earnings History', 'rectangle-list', 'wb'); ?>
    <div class="ma_content">
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th class="align center">Coin</th>
              <th>Info</th>
              <th>Mining ID</th>
              <th>Value</th>
              <th>Date Time</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_earnings): foreach($the_earnings as $earning): ?>
            <tr>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $earning->ea_coin)->co_img); ?>" alt="<?= em_get_coin('id', $earning->ea_coin)->co_name; ?>"></td>
              <td><?= em_earn_info($earning->ea_info); ?></td>
              <td><?= $earning->ea_mining ? $earning->ea_mining : '-'; ?></td>
              <td><?= em_con_decimal($earning->ea_value); ?> <?= em_get_coin('id', $earning->ea_coin)->co_symbol; ?></td>
              <td><?= em_time_full($earning->ea_date); ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(5); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_earnings){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>
