<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Deposits History', 'cash-register', 'wb'); ?>
    <div class="ma_content">
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th>Txid</th>
              <th class="align center">Coin</th>
              <th>Info</th>
              <th>Value</th>
              <th>Date Time</th>
              <th colspan="2">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_deposits): foreach($the_deposits as $deposit): ?>
            <tr>
              <td><?= $deposit->mi_tx; ?></td>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $deposit->mi_coin)->co_img); ?>" alt="<?= em_get_coin('id', $deposit->mi_coin)->co_name; ?>"></td>
              <td><?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?> Mining (<?= $deposit->mi_plans; ?>)</td>
              <td><?= em_con_decimal($deposit->mi_deposit); ?> <?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?></td>
              <td><?= em_time_full($deposit->mi_date); ?></td>
              <td><?= (int)$deposit->mi_status < 1 ? '<span class="tsts">Unpaid</span>' : ((int)$deposit->mi_status > 2 ? '<span class="tsts s2">Ignored</span>' : '<span class="tsts s1">Paid</span>'); ?></td>
              <td><?= (int)$deposit->mi_status < 1 ? '<a href="'.em_site_url('dash/plans/'.em_get_coin('id', $deposit->mi_coin)->co_symbol.'/deposit/?tx='.$deposit->mi_tx).'" title="Pay it off">Pay it off</a>' : '-'; ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(6); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_deposits){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>
