<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Deposit Invoice', 'cash-register', 'wb'); ?>
    <div class="em_deposit_invoice">
      <div class="di_head">
        <span class="dih_tit">Deposit Amount</span>
        <div class="dih_val"><span><?= em_con_decimal($the_depo->mi_deposit); ?></span><label><?= em_get_coin('id', $the_depo->mi_coin)->co_symbol; ?></label></div>
        <div class="dih_met"><label>Via</label><span><?= em_depo_method($the_depo->mi_depo_mtd); ?></span></div>
      </div>
      <div class="di_merchant">
        <div style="display: none;">
          <?php if($the_depo->mi_depo_mtd == 'hp' && em_config('finance.hspay.depo_status')){
            $api_key = em_config('finance.hspay.merchant_api');
            $url = 'https://hspay.io/api/v1/merchant/';
            $data = [
              "item_desc"    => 'Deposit for '.em_get_coin('id', $the_depo->mi_coin)->co_symbol.' Mining ('.$the_depo->mi_tx.')',
              "amount"       => $the_depo->mi_deposit,
              "crypto_1"     => em_get_coin('id', $the_depo->mi_coin)->co_symbol,
              "custom_id"    => $the_depo->mi_tx,
              "webhook_url"  => em_site_url('api/hspay/'),
              "paid_url"     => em_site_url('dash/user/deposits/'),
              "cancel_url"   => em_site_url('dash/plans/'.em_get_coin('id', $the_depo->mi_coin)->co_symbol.'/deposit/?tx='.$the_depo->mi_tx)
            ];
            $e_data = json_encode($data);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $e_data);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json','api-key: '.$api_key]);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            $response = curl_exec($ch);
            $result = json_decode($response, true);
          } ?>
        </div>
        <div class="dim_act">
          <?php if($result['data']['pay_url']): ?>
            <a class="dima_link" href="<?= $result['data']['pay_url']; ?>" title="Click to Complete Deposit"><i class="fa-solid fa-cash-register"></i><span>Click to Complete Deposit</span></a>
          <?php else: ?>
            <div class="dima_status">
            <a href=".?tx=<?= $the_depo->mi_tx; ?>" title="Refresh"><i class="fa-solid fa-rotate"></i><span>Refresh</span></a>
            <label>Failed to Get Deposit URL</span>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <div class="ma_row">
    <span class="ma_hi"><strong>Important</strong>: Deposit invoice will expire if not paid within 24 hours</span>
    <div class="ma_content">
      <div class="em_table">
        <table>
          <tbody>
            <tr><td class="par">TX Code</td><td><?= $the_depo->mi_tx; ?></td></tr>
            <tr><td class="par">Coin</td><td><?= em_get_coin('id', $the_depo->mi_coin)->co_name; ?> (<?= em_get_coin('id', $the_depo->mi_coin)->co_symbol; ?>)</td></tr>
            <tr><td class="par">Plan Name</td><td><?= $the_depo->mi_plans; ?></td></tr>
            <tr><td class="par">Daily Return</td><td><?= em_con_decimal($the_depo->mi_daily); ?> <?= em_get_coin('id', $the_depo->mi_coin)->co_symbol; ?></td></tr>
            <tr><td class="par">Durations</td><td><?= $the_depo->mi_days; ?> Days</td></tr>
            <tr><td class="par">Date Time</td><td><?= em_time_full($the_depo->mi_date); ?></td></tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
