<?php
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
//////////////////////////////////////////////////////////////////////////////
// System function Control Center
//////////////////////////////////////////////////////////////////////////////
function em_app_loader($class){
  $class = str_replace('\\', '/', $class);
  $file = em_app_path('app/'.$class.'.php');
  if(file_exists($file)) require_once $file;
}

function em_app(){
  global $app;
  return $app;
}

function em_db(){
  global $app;
  return $app->db();
}

function em_dbtb($table){
  return DB_APS_CODE.'_'.$table;
}

function em_script_ver(){
  return rand(1000, 999999);
}

//////////////////////////////////////////////////////////////////////////////
/// URL & PATH
//////////////////////////////////////////////////////////////////////////////
function em_site_url($path = NULL){
  return APP_SITE.$path;
}

function em_admin_url($path = NULL){
  return APP_SITE.'em-admin/'.$path;
}

function em_asset_url($path){
  return APP_SITE.'em-assets/'.$path;
}

function em_app_path($path){
	return APP_PATH.'/'.$path;
}

function em_public_path($path){
  return APP_PATH.'/public/'.$path;
}

function em_index_path($path){
	return APP_PATH.'/../'.$path;
}

function em_theme_path($path){
	return APP_PATH.'/../em-theme/'.$path;
}

function em_admin_path($path){
	return APP_PATH.'/../em-admin/'.$path;
}

//////////////////////////////////////////////////////////////////////////////
/// CONFIG
//////////////////////////////////////////////////////////////////////////////
function em_config($path){
	global $app;
	return $app->config($path);
}

function em_mail($path){
  global $app;
	return $app->mail_msg($path);
}

function em_dbjson($json){
  $get_json = json_decode($json, true);
  return $get_json;
}

function em_getip(){
  if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])){
    $_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
    $_SERVER['HTTP_CLIENT_IP'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
  }
  $client  = @$_SERVER['HTTP_CLIENT_IP'];
  $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
  $remote  = @$_SERVER['REMOTE_ADDR'];
  if(filter_var($client, FILTER_VALIDATE_IP)) $ip = $client;
  elseif(filter_var($forward, FILTER_VALIDATE_IP)) $ip = $forward;
  else $ip = $remote;
  return $ip;
}

function em_alert($type, $message){
  \systems\alert::put($type, $message);
}

function em_get_coin($type, $val){
  if($type === 'symbol'){
    $coin = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' WHERE co_symbol = ?');
    $coin->execute([$val]); $coin = $coin->fetch(\PDO::FETCH_OBJ);
  } else {
    $coin = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' WHERE id = ?');
    $coin->execute([$val]); $coin = $coin->fetch(\PDO::FETCH_OBJ);
  } return $coin;
}

function em_hspay($type, $content, $content2 = NULL, $content3 = NULL, $content4 = NULL){
  $hsp_api = em_config('finance.hspay.faucet_api');
  $hsp_url = 'https://hspay.io/api/v1/';
  $hsp_mtd = null;

  if($type === 'crypto'){
    $hsp_dta = '?'.http_build_query(['crypto' => $content]);
    $hsp_url = $hsp_url.'get-crypto/'.$hsp_dta;
    $hsp_mtd = 'GET';
  } elseif($type === 'user'){
    $hsp_dta = '?'.http_build_query(['user' => $content]);
    $hsp_url = $hsp_url.'get-user/'.$hsp_dta;
    $hsp_mtd = 'GET';
  } elseif($type === 'balance'){
    $hsp_dta = '?'.http_build_query(['crypto' => $content]);
    $hsp_url = $hsp_url.'get-balance/'.$hsp_dta;
    $hsp_mtd = 'GET';
  } elseif($type === 'payment'){
    $hsp_dta = json_encode(["user" => $content, "crypto" => $content2, "amount" => $content3, "ip_address" => $content4]);
    $hsp_url = $hsp_url.'send-payment/';
    $hsp_mtd = 'POST';
  } else {return false;}

  if($hsp_mtd){
    if($hsp_mtd == 'GET'){
      $hsp_ch = curl_init($hsp_url);
      curl_setopt($hsp_ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($hsp_ch, CURLOPT_CUSTOMREQUEST, 'GET');
      curl_setopt($hsp_ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'api-key: '.$hsp_api]);
      curl_setopt($hsp_ch, CURLOPT_TIMEOUT, 10);
      $hsp_response = curl_exec($hsp_ch);
      $hsp_result = json_decode($hsp_response, true);
      return $hsp_result;
    } elseif($hsp_mtd == 'POST'){
      $hsp_ch = curl_init($hsp_url);
      curl_setopt($hsp_ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($hsp_ch, CURLOPT_CUSTOMREQUEST, 'POST');
      curl_setopt($hsp_ch, CURLOPT_POSTFIELDS, $hsp_dta);
      curl_setopt($hsp_ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', 'api-key: '.$hsp_api]);
      curl_setopt($hsp_ch, CURLOPT_TIMEOUT, 10);
      $hsp_response = curl_exec($hsp_ch);
      $hsp_result = json_decode($hsp_response, true);
      return $hsp_result;
    } else {return false;}
  } else {return false;}
}

//////////////////////////////////////////////////////////////////////////////
/// FORMS
//////////////////////////////////////////////////////////////////////////////
function em_form_get($key){
  if(isset($_GET[$key]) && !empty($_GET[$key])) return $_GET[$key];
  return;
}

function em_form_post($key){
  if(isset($_POST[$key]) && !empty($_POST[$key])) return $_POST[$key];
  return;
}

function em_form_file($key, $array){
  if(isset($_FILES[$key]) && !empty($_FILES[$key])) return $_FILES[$key][$array];
  return;
}

function em_form_csrf(){
  $token = systems\csrf::generate();
  return $token;
}

function em_form_token(){
  return bin2hex(random_bytes(32));
}

function em_form_verify(){
  return strtoupper(bin2hex(random_bytes(3)));
}

function em_form_return($errors, $redirect = null){
  if(empty($errors)){
    $response = ['success' => true];
    if($redirect) $response['redirect'] = $redirect;
  } else {
    $response = ['messages' => $errors];
  } return json_encode($response);
}

function em_form_return_media($errors, $redirect = null){
	if(empty($errors)){
		$response = 'true~non';
		if($redirect) $response = 'true~'.$redirect;
		echo $response;
	} else {
		$response = $errors;
		foreach($response as $res){
			echo '<li>'.$res.'</li>';
		}
	}
}

function em_error($code){
  switch($code){
		case 404:
			http_response_code(404);
			header('Location: /404/');
		break;
	} exit;
}

//////////////////////////////////////////////////////////////////////////////
/// FORMS INPUT
//////////////////////////////////////////////////////////////////////////////
function em_form_get_input($cont, $title, $type, $name, $value = null, $require = true, $readonly = false){
  $finp = '';
  if($require){$ireq = '<i>*</i>';} else {$ireq = '';}
  if($value !== NULL){$ivalue = ' value="'.$value.'"';} else {$ivalue = '';}
  if($type === 'number'){$stnum = ' step="any"';} else {$stnum = '';}
  if($readonly){$ireaon = ' readonly';} else {$ireaon = '';}
  $finp .= '<div class="'.$cont.'">';
    $finp .= '<div class="f_input">';
      $finp .= '<div class="fi_title"><span>'.$title.'</span>'.$ireq.'</div>';
      $finp .= '<input class="fi_inp" type="'.$type.'" name="'.$name.'"'.$ivalue.$stnum.$ireaon.'>';
      if($type == 'password') $finp .= '<div class="fi_pass"><i class="fa-solid fa-eye"></i></div>';
    $finp .= '</div>';
  $finp .= '</div>';
  return $finp;
}

function em_form_get_select($cont, $title, $name, $value = null, $val_con = null, $require = true, $disabled = false){
  $fsel = '';
  if($require){$ireq = '<i>*</i>';} else {$ireq = '';}
  if($disabled){$idis = ' disabled';} else {$idis = '';}
  $fsel .= '<div class="'.$cont.'">';
    $fsel .= '<div class="f_select">';
      $fsel .= '<div class="fs_title"><span>'.$title.'</span>'.$ireq.'</div>';
      $fsel .= '<select name="'.$name.'"'.$idis.'>';
        if($value){
          foreach(json_decode($value) as $key => $val){
            if($val_con){$vc = ($val_con == $key) ? ' selected' : '';} else {$vc = '';}
            $fsel .= '<option value="'.$key.'"'.$vc.'>'.$val.'</option>';
          }
        } else $fsel .= '<option value="null">No option..</option>';
      $fsel .= '</select>';
    $fsel .= '</div>';
  $fsel .= '</div>';
  return $fsel;
}

function em_form_get_check($cont, $title, $text, $name, $require = true, $condition = NULL, $readonly = false){
  $fcheck = '';
  if($condition){$cond = $condition;} else {$cond = '';}
  if($require){$req = '<i>*</i>';} else {$req = '';}
  if($readonly){$rdo = ' disabled';} else {$rdo = '';}
  $fcheck .= '<div class="'.$cont.'">';
    $fcheck .= '<div class="f_check">';
      if($title){
        $fcheck .= '<div class="fc_title">';
          $fcheck .= '<label class="ttl">'.$title.$req.'</label>';
        $fcheck .= '</div>';
      }
      $fcheck .= '<div class="fc_box">';
        $fcheck .= '<input type="checkbox" name="'.$name.'" value="true"'.$cond.$rdo.'>';
        $fcheck .= '<div class="fcb_mark"></div>';
        $fcheck .= '<span>'.$text.'</span>';
      $fcheck .= '</div>';
    $fcheck .= '</div>';
  $fcheck .= '</div>';
  return $fcheck;
}

function em_form_get_upload($cont, $title, $text, $name, $accept, $demo = null, $demo_size = 1, $require = false){
  $fupl = '';
  if($require){$ureq = '<i>*</i>';} else {$ureq = '';}
  $fupl .= '<div class="'.$cont.'">';
    $fupl .= '<div class="f_upload">';
      $fupl .= '<div class="fu_title"><span>'.$title.'</span>'.$ureq.'</div>';
      if($demo){
        if((int)$demo_size === 1){$ds = ' fud_s';} elseif((int)$demo_size === 2){$ds = ' fud_m';} else {$ds = ' fud_b';}
        $fupl .= '<div class="fu_demo'.$ds.'">';
          $fupl .= '<img src="'.$demo.'" alt="Demo">';
        $fupl .= '</div>';
      }
      $fupl .= '<input class="fu_inp" type="file" name="'.$name.'" accept="'.$accept.'">';
      $fupl .= '<span class="fu_text">'.$text.'</span>';
    $fupl .= '</div>';
  $fupl .= '</div>';
  return $fupl;
}

function em_form_get_plans($cont, $title, $label, $name, $value = null, $require = true){
  $fpln = '';
  if($require){$ireq = '<i>*</i>';} else {$ireq = '';}
  $arr_label = json_decode($label);
  $arr_name = json_decode($name);
  $fpln .= '<div class="'.$cont.'">';
    $fpln .= '<div class="f_plans">';
      $fpln .= '<div class="fp_title"><span>'.$title.'</span>'.$ireq.'</div>';
      $fpln .= '<div class="fp_box">';
        if($value){
          $val_arr = json_decode($value); $val_count = 0;
          if($val_arr){foreach($val_arr as $day => $daily){$val_count++;
            $fpln .= '<div class="fpb_group">';
              $fpln .= '<div class="fpbg_inp">';
                $fpln .= '<span class="fpbgi_title">'.$arr_label[0].'</span>';
                $fpln .= '<input type="number" name="'.$arr_name[0].'['.$val_count.']" value="'.$day.'" placeholder="5" step="any">';
              $fpln .= '</div>';
              $fpln .= '<div class="fpbg_inp">';
                $fpln .= '<span class="fpbgi_title">'.$arr_label[1].'</span>';
                $fpln .= '<input type="number" name="'.$arr_name[1].'['.$val_count.']" value="'.$daily.'" placeholder="0.99000000" step="any">';
              $fpln .= '</div>';
              $fpln .= '<div class="fpbg_btn">';
                if($val_count > 1){$fpln .= '<div class="fpbgb min" title="min"><i class="fa-solid fa-minus"></i></div>';}
                $fpln .= '<div class="fpbgb add" title="add"><i class="fa-solid fa-plus"></i></div>';
              $fpln .= '</div>';
            $fpln .= '</div>';
          }}
        } else {
          $fpln .= '<div class="fpb_group">';
            $fpln .= '<div class="fpbg_inp">';
              $fpln .= '<span class="fpbgi_title">'.$arr_label[0].'</span>';
              $fpln .= '<input type="number" name="'.$arr_name[0].'[1]" placeholder="5" step="any">';
            $fpln .= '</div>';
            $fpln .= '<div class="fpbg_inp">';
              $fpln .= '<span class="fpbgi_title">'.$arr_label[1].'</span>';
              $fpln .= '<input type="number" name="'.$arr_name[1].'[1]" placeholder="0.99000000" step="any">';
            $fpln .= '</div>';
            $fpln .= '<div class="fpbg_btn"><div class="fpbgb add" title="add"><i class="fa-solid fa-plus"></i></div></div>';
          $fpln .= '</div>';
        }
      $fpln .= '</div>';
    $fpln .= '</div>';
  $fpln .= '</div>';
  return $fpln;
}

function em_form_get_btn($cont, $title, $icon = null, $class = false, $disabled = true){
  $fbtn = '';
  if($disabled){$disable = ' disabled';} else {$disable = '';}
  if($class){$classes = ' class="scnd"';} else {$classes = ' class="prim"';}
  if($icon){$bicon = '<i class="'.$icon.'"></i>';} else {$bicon = '';}
  $fbtn .= '<div class="'.$cont.'">';
    $fbtn .= '<div class="f_submit">';
      $fbtn .= '<button'.$classes.' type="submit"'.$disable.'>'.$bicon.'<span>'.$title.'</span></button>';
      $fbtn .= '<div class="em_form_msg dnone"></div>';
    $fbtn .= '</div>';
  $fbtn .= '</div>';
  return $fbtn;
}

//////////////////////////////////////////////////////////////////////////////
/// DATETIME
//////////////////////////////////////////////////////////////////////////////
function em_time_row(){
  return date('Y-m-d H:i:s', time());
}

function em_time_ago($time){
	if($time != null){
		$timestamp = strtotime($time);
		$strTime = array('seconds', 'minutes', 'hours', 'days', 'month', 'year');
		$length = array("60", "60", "24", "30", "12", "365000");

		$currentTime = strtotime(date('Y-m-d H:i:s', time()));
		if($currentTime >= $timestamp){
			$diff = $currentTime - $timestamp;
			for($i = 0; $diff >= $length[$i] && $i < count($length)-1; $i++) $diff = $diff / $length[$i];
			$diff = round($diff);
			if($strTime[$i] == 'seconds'){
				return 'Just Now';
			} else {
				return $diff ." ". $strTime[$i] ." ago";
			}
		}
	} else return '-';
}

function em_time_full($date){
  if($date){
		$timestamp = strtotime($date);
		$hour = date('H', $timestamp);
		$minutes = date('i', $timestamp);
		$sec = date('s', $timestamp);
		$day = date('d', $timestamp);
		$month = date('F', $timestamp);
		$year = date('Y', $timestamp);
		return $day.' '.$month.' '.$year.' - '.$hour.':'.$minutes;
	} else return '-';
}

function em_time_modif($modif, $date){
  $modTime = DateTime::createFromFormat('Y-m-d H:i:s', $date);
  $modTime->modify($modif); $modTime = $modTime->format('Y-m-d H:i:s');
  return $modTime;
}

//////////////////////////////////////////////////////////////////////////////
/// USERS
//////////////////////////////////////////////////////////////////////////////
function em_user(){
	global $app;
	return $app->user;
}

function em_this_user($val){
  return em_user()->user->$val;
}

function em_get_user($uid){
  $user = em_db()->prepare('SELECT * FROM '.em_dbtb('users').' WHERE uid = ?');
  $user->execute([$uid]); $user = $user->fetch(\PDO::FETCH_OBJ);
  return $user;
}

function em_user_balance($uid){
  $user = em_db()->prepare('SELECT * FROM '.em_dbtb('users_balance').' WHERE ub_user = ?');
  $user->execute([$uid]); $user = $user->fetch(\PDO::FETCH_OBJ);
  if($user){return $user;} else {return 'null';}
}

function em_user_cookie($uniq){
	return setcookie('emuniq', $uniq, time() + 7776666, "/");
}

//////////////////////////////////////////////////////////////////////////////
/// VARIABLE
//////////////////////////////////////////////////////////////////////////////
function em_depo_method($mtd){
  if($mtd){
    if($mtd === 'hp'){
      return 'HSPay';
    } else return 'Unknown';
  } else return 'Unknown';
}

function em_wd_method($mtd){
  if($mtd){
    if((int)$mtd === 1){
      return 'HSPay';
    } else return 'Unknown';
  } else return 'Unknown';
}

function em_earn_info($info){
  if($info){
    if($info === 'earn_1'){
      return 'Harvest the Mining Daily Return';
    } elseif($info === 'earn_2'){
      return 'Added by Admin';
    } elseif($info === 'earn_3'){
      return 'Reduce by Admin';
    } else return 'Unknown';
  } else return 'Unknown';
}

function em_getdb_value($type, $col, $table, $where = NULL, $value = NULL){
  $c_type = ($type === 'sum') ? "SUM($col)" : "COUNT($col)";
  $c_where = ($where) ? " WHERE $where" : "";

  $dbval = em_db()->prepare("SELECT $c_type AS value FROM $table$c_where");
  if($value && is_array($value)){$dbval->execute($value);} else {$dbval->execute();}
  $dbval = $dbval->fetch(\PDO::FETCH_OBJ);
  $dbval = ($dbval->value == null) ? 0 : $dbval->value;
  return $dbval;
}

//////////////////////////////////////////////////////////////////////////////
/// ELEMENTS
//////////////////////////////////////////////////////////////////////////////
function em_page_title($head, $title, $icon = NULL, $class = NULL, $link = NULL, $linktext = NULL, $linkicon = NULL, $cid = NULL){
  if($class){$addclass = ' '.$class;} else {$addclass = '';}
  if($cid){$addId = ' id="'.$cid.'"';} else {$addId = '';}
  $c_title = '';
  $c_title .= '<div class="ma_title'.$addclass.'"'.$addId.'>';
    $c_title .= '<'.$head.'>';
      if($icon){$c_title .= '<i class="fa-solid fa-'.$icon.'"></i>';}
      $c_title .= '<span>'.$title.'</span>';
    $c_title .= '</'.$head.'>';
    if($link){
      $c_title .= '<a href="'.$link.'" title="'.$linktext.'">';
        if($linkicon){$c_title .= '<i class="fa-solid fa-'.$linkicon.'"></i>';}
        $c_title .= '<span>'.$linktext.'</span>';
      $c_title .= '</a>';
    }
  $c_title .= '</div>';
  return $c_title;
}

function em_page_null($text, $icon = NULL){
  $null = '';
  $null .= '<div class="em_nothing">';
    if($icon) $null .= '<i class="fa-solid fa-'.$icon.'"></i>';
    $null .= '<span>'.$text.'</span>';
  $null .= '</div>';
  return $null;
}

function em_table_null($col){
  $tablenull = '';
  $tablenull .= '<tr>';
  $tablenull .= '<td colspan="'.$col.'" style="color: var(--col_text);padding: 40px 10px;text-align: center;">There is no record..</td>';
  $tablenull .= '</tr>';
  return $tablenull;
}

function em_num_decimal($amount){
  return number_format((float)$amount, 8, '.', ',');
}

function em_pure_decimal($amount){
  return number_format((float)$amount, 8, '.', '');
}

function em_con_decimal($amount){
  $negative = $amount < 0 ? '-' : '';
  $amount = abs((float)$amount);

  if($amount < 10){
    return $negative.number_format($amount, 8, '.', ',');
  } elseif($amount >= 10 && $amount < 1000){
    return $negative.number_format($amount, 4, '.', ',');
  } else {
    return $negative.number_format($amount, 1, '.', ',');
  }
}

function em_pure_con_decimal($amount){
  if((float)$amount < 10){
    return number_format((float)$amount, 8, '.', '');
  } elseif((float)$amount >= 10 && $amount < 1000){
    return number_format((float)$amount, 4, '.', '');
  } else {
    return number_format((float)$amount, 1, '.', '');
  }
}

function em_infobox($text){
  $infobox = '';
  $infobox .= '<div class="em_infobox">';
    $infobox .= $text;
  $infobox .= '</div>';
  return $infobox;
}

//////////////////////////////////////////////////////////////////////////////
/// THEMES
//////////////////////////////////////////////////////////////////////////////
function em_theme_minified($wrap){
  $search = array(
    '/[^\S ]+\</s',
    '/\>[^\S ]+/s',
    '/(\s)+/s',
    '/<!--(.|\s)*?-->/',
    '/<ppbreak\/>/'
  );
  $replace = array('<', '>', '\\1', '', "\n");
  $output = preg_replace($search, $replace, $wrap);
  return $output;
}

function em_header($type, $title, $robots){
  $set_type = $type;
  $set_title = $title;
  $set_robot = $robots;
  require_once em_theme_path('part/head.php');
}

function em_footer(){
  require_once em_theme_path('part/foot.php');
}

function em_header_admin($title){
  $set_title = $title;
  require_once em_admin_path('part/head.php');
}

function em_footer_admin(){
  require_once em_admin_path('part/foot.php');
}

function em_custom_css(){
  echo '#emerel-cms {';
  echo '--col_primary: '.em_config('style.color.primary').';';
  echo '--col_primary_sup: '.em_config('style.color.primary_sup').';';
  echo '--col_primary_text: '.em_config('style.color.primary_text').';';
  echo '--col_second: '.em_config('style.color.second').';';
  echo '--col_second_sup: '.em_config('style.color.second_sup').';';
  echo '--col_second_text: '.em_config('style.color.second_text').';';
  echo '--col_error: '.em_config('style.color.error').';';
  echo '--col_error_sup: '.em_config('style.color.error_sup').';';
  echo '--col_error_text: '.em_config('style.color.error_text').';';
  echo '--col_success: '.em_config('style.color.success').';';
  echo '--col_success_sup: '.em_config('style.color.success_sup').';';
  echo '--col_success_text: '.em_config('style.color.success_text').';';
  echo '--glo_font: '.em_config('style.font').';';
  echo '--glo_trans: '.em_config('style.trans').';';
  echo '--glo_radius: '.em_config('style.radius').';';
  echo '--glo_scaleu: '.em_config('style.scaleu').';';
  echo '--glo_scaled: '.em_config('style.scaled').';';
  echo '--glo_bshadow: 0 2px 10px 0 #0003;';
  echo '--glo_bshadow2: 0 12px 10px 0 #0003;';
  echo '}';
  echo 'html, body{margin: 0;padding: 0;font-weight: 400;}';
  foreach(glob(em_index_path('em-assets/font/*')) as $font){
		if(is_file($font)){
			$font_basename = basename($font);
			$font_code = substr($font_basename, 0, strrpos($font_basename, "."));
			$font_name = str_replace('-', ' ', $font_code);
			if(em_config('style.font') == $font_code){
				echo 'html, body, button, input, select, textarea{--site_font: "'.ucwords($font_name).'";font-family: var(--site_font), sans-serif;}';
			}
		}
	}
}

function em_meta_font(){
	$font_list = glob(em_index_path('em-assets/font/*'));
	$dis_font = '';
	$dis_font .= '<div style="position: absolute;">';
	foreach($font_list as $font){
	  $font_basename = basename($font);
	  if(is_file($font) && $font_basename != 'roboto.css'){
	    $dis_font .= '<link rel="stylesheet" type="text/css" href="'.em_asset_url('font/'.$font_basename).'?ver=1.0.0">';
	  }
	}
	$dis_font .= '</div>';
	echo $dis_font;
}

function em_meta_dev(){
  $dev = '';
	$dev .= "\n"."\n".'<!-- Dev Person - Telegram: @rizkilutfhi15'."\n";
	$dev .= '───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────'."\n";
	$dev .= '─██████████████─██████──────────██████─██████████████─████████████████───██████████████─██████────────────────████████──████████─████████──████████─██████████████████─'."\n";
	$dev .= '─██░░░░░░░░░░██─██░░██████████████░░██─██░░░░░░░░░░██─██░░░░░░░░░░░░██───██░░░░░░░░░░██─██░░██────────────────██░░░░██──██░░░░██─██░░░░██──██░░░░██─██░░░░░░░░░░░░░░██─'."\n";
	$dev .= '─██░░██████████─██░░░░░░░░░░░░░░░░░░██─██░░██████████─██░░████████░░██───██░░██████████─██░░██────────────────████░░██──██░░████─████░░██──██░░████─████████████░░░░██─'."\n";
	$dev .= '─██░░██─────────██░░██████░░██████░░██─██░░██─────────██░░██────██░░██───██░░██─────────██░░██──────────────────██░░░░██░░░░██─────██░░░░██░░░░██───────────████░░████─'."\n";
	$dev .= '─██░░██████████─██░░██──██░░██──██░░██─██░░██████████─██░░████████░░██───██░░██████████─██░░██──────────────────████░░░░░░████─────████░░░░░░████─────────████░░████───'."\n";
	$dev .= '─██░░░░░░░░░░██─██░░██──██░░██──██░░██─██░░░░░░░░░░██─██░░░░░░░░░░░░██───██░░░░░░░░░░██─██░░██────────────────────██░░░░░░██─────────████░░████─────────████░░████─────'."\n";
	$dev .= '─██░░██████████─██░░██──██████──██░░██─██░░██████████─██░░██████░░████───██░░██████████─██░░██──────────────────████░░░░░░████─────────██░░██─────────████░░████───────'."\n";
	$dev .= '─██░░██─────────██░░██──────────██░░██─██░░██─────────██░░██──██░░██─────██░░██─────────██░░██──────────────────██░░░░██░░░░██─────────██░░██───────████░░████─────────'."\n";
	$dev .= '─██░░██████████─██░░██──────────██░░██─██░░██████████─██░░██──██░░██████─██░░██████████─██░░██████████─██████─████░░██──██░░████───────██░░██───────██░░░░████████████─'."\n";
	$dev .= '─██░░░░░░░░░░██─██░░██──────────██░░██─██░░░░░░░░░░██─██░░██──██░░░░░░██─██░░░░░░░░░░██─██░░░░░░░░░░██─██░░██─██░░░░██──██░░░░██───────██░░██───────██░░░░░░░░░░░░░░██─'."\n";
	$dev .= '─██████████████─██████──────────██████─██████████████─██████──██████████─██████████████─██████████████─██████─████████──████████───────██████───────██████████████████─'."\n";
	$dev .= '───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────'."\n";
	$dev .= 'Dev Person - Telegram: @rizkilutfhi15 -->'."\n";
	return $dev;
}

function em_modal($id, $title, $content, $display = false){
  if($display){
    $modis = ' style="display: flex;"';
    $close = '';
  } else {
    $modis = '';
    $close = '<div class="mmh_close"><i class="fa-solid fa-xmark"></i></div>';
  }
  $modal = '';
  $modal .= '<div class="em_modal" id="'.$id.'"'.$modis.'>';
    $modal .= '<div class="m_overlay"></div>';
    $modal .= '<div class="m_main">';
      $modal .= '<div class="mm_head">';
        $modal .= '<h3 class="mmh_title">'.$title.'</h3>';
        $modal .= $close;
      $modal .= '</div>';
      $modal .= '<div class="mm_content">';
        $modal .= $content;
      $modal .= '</div>';
    $modal .= '</div>';
  $modal .= '</div>';
  return $modal;
}
