<?php
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
//////////////////////////////////////////////////////////////////////////////
// The Handler Systems
//////////////////////////////////////////////////////////////////////////////
require_once __DIR__ .'/models.php';
spl_autoload_register('em_app_loader');
require_once __DIR__ .'/sets.php';
$app = new systems\core;

//////////////////////////////////////////////////////////////////////////////
// The Log Handler
//////////////////////////////////////////////////////////////////////////////
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);
$LogErr = __DIR__.'/../em-assets/logs/errors.log';
$LogWar = __DIR__.'/../em-assets/logs/warning.log';
set_error_handler(function($errno, $errstr, $errfile, $errline) use ($LogErr, $LogWar){
  $LgDate = date('Y-m-d H:i:s');
  $LgMsg = "[$LgDate] ";
  switch($errno){
    case E_ERROR:
    case E_USER_ERROR:
    case E_CORE_ERROR:
    case E_COMPILE_ERROR:
    case E_RECOVERABLE_ERROR:
        $LgMsg .= "Fatal Error: $errstr in $errfile on line $errline" . PHP_EOL;
        error_log($LgMsg, 3, $LogErr);
        break;
    case E_WARNING:
    case E_USER_WARNING:
    case E_CORE_WARNING:
    case E_COMPILE_WARNING:
        $LgMsg .= "Warning: $errstr in $errfile on line $errline" . PHP_EOL;
        error_log($LgMsg, 3, $LogWar);
        break;
  } return true;
});
register_shutdown_function(function() use ($LogErr) {
  $error = error_get_last();
  if ($error && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
    $LgDate = date('Y-m-d H:i:s');
    $LgMsg = "[$LgDate] Fatal Shutdown Error: {$error['message']} in {$error['file']} on line {$error['line']}" . PHP_EOL;
    error_log($LgMsg, 3, $LogErr);
  }
});
