<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$uid = em_form_get('u');
if($uid){
  $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." WHERE uid = ?");
  $the_users->execute([$uid]); $the_users = $the_users->fetch(\PDO::FETCH_OBJ);
  if($the_users){
    $the_coins = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' ORDER BY id ASC');
    $the_coins->execute(); $the_coins = $the_coins->fetchAll(\PDO::FETCH_OBJ);
    $coin_json = [];
    foreach($the_coins as $coin){$coin_json[$coin->id] = $coin->co_name.' ('.$coin->co_symbol.')';}
    $fin_coin = json_encode($coin_json, JSON_PRETTY_PRINT);

    $the_logs = em_db()->prepare("SELECT * FROM ".em_dbtb('users_log')." WHERE ul_user = ? ORDER BY id DESC LIMIT 10");
    $the_logs->execute([$the_users->uid]); $the_logs = $the_logs->fetchAll(\PDO::FETCH_OBJ);
  } else em_error(404);
} else em_error(404);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
em_header_admin('User: #'.$the_users->uid); ?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'User: #'.$the_users->uid, 'user', 'wb', em_admin_url('users/'), 'Back', 'arrow-left'); ?>
    <div class="ma_content">
      <div class="em_form">
        <div class="f_col c2">
          <?= em_form_get_input('f_row', 'User ID', 'text', '', $the_users->uid); ?>
          <?= em_form_get_input('f_row', 'User Email', 'text', '', $the_users->usr_email); ?>
          <?= em_form_get_input('f_row', 'IP Address', 'text', '', $the_users->usr_ip); ?>
          <?= em_form_get_input('f_row', 'Last Activity', 'text', '', em_time_ago($the_users->usr_activity)); ?>
          <?= em_form_get_input('f_row', 'Registration Date', 'text', '', em_time_full($the_users->usr_regdate)); ?>
          <?= em_form_get_input('f_row', 'Status', 'text', '', (int)$the_users->usr_status === 0 ? 'Inactive' : ((int)$the_users->usr_status === 1 ? 'Active' : 'Banned')); ?>
        </div>
        <div class="f_col c1" style="margin: 20px 0 0;">
          <div class="f_row"><div class="ma_flexbtn fb0 em_modal_btn" for-mod="edit_status"><i class="fa-solid fa-pen-to-square"></i><span>Edit Status</span></div></div>
        </div>
        <div class="f_col c2" style="margin: 20px 0 0;">
          <div class="f_row"><a href="<?= em_admin_url('users/mining/?u='.$the_users->uid); ?>" class="ma_flexbtn fb2"><i class="fa-solid fa-user-gear"></i><span>Mining Lists</span></a></div>
          <div class="f_row"><a href="<?= em_admin_url('finance/earnings/?user='.$the_users->uid); ?>" class="ma_flexbtn fb1"><i class="fa-solid fa-rectangle-list"></i><span>Earnings</span></a></div>
          <div class="f_row"><a href="<?= em_admin_url('finance/deposits/?user='.$the_users->uid); ?>" class="ma_flexbtn fb1"><i class="fa-solid fa-cash-register"></i><span>Deposits</span></a></div>
          <div class="f_row"><a href="<?= em_admin_url('finance/withdrawals/?user='.$the_users->uid); ?>" class="ma_flexbtn fb2"><i class="fa-solid fa-wallet"></i><span>Withdrawals</span></a></div>
        </div>
      </div>
    </div>
  </div>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Assets', 'coins', 'nm'); ?>
      <div class="em_form">
        <div class="f_col c2">
          <?php if($the_coins): foreach($the_coins as $coin):
            $ub_prefix = 'ub_'.strtolower($coin->co_symbol);
            echo em_form_get_input('f_row', $coin->co_name.'('.$coin->co_symbol.')', 'text', '', em_user_balance($the_users->uid)->$ub_prefix);
          endforeach; endif; ?>
        </div>
      </div>
      <div class="ma_flexbtn fb2 em_modal_btn" for-mod="edit_asset"><i class="fa-solid fa-pen-to-square"></i><span>Edit Assets</span></div>
    </div>
  </div>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Logs', 'right-to-bracket', 'nm'); ?>
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th>Info</th>
              <th>Ip Address</th>
              <th>Date Time</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_logs): foreach($the_logs as $log): ?>
            <tr>
              <td>Account Login Successfully</td>
              <td><?= $log->ul_ip; ?></td>
              <td><?= em_time_full($log->ul_date); ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(3); endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?= em_modal('edit_status', 'Edit User Status', '
  <div class="em_form">
    <div class="f_data" id="a-uSR27s/'.em_form_csrf().'">
      <div class="f_col c1">
        '.em_form_get_select('f_row', 'Type', 'ua_type', '{"1": "Active", "2": "Banned", "3": "Delete Account"}', (int)$the_users->usr_status, true, false).'
        <input type="hidden" name="ua_id" value="'.$the_users->uid.'">
        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true).'
      </div>
    </div>
  </div>
'); ?>
<?= em_modal('edit_asset', 'Edit User Assets', '
  <div class="em_form">
    <div class="f_data" id="a-U2rA27/'.em_form_csrf().'">
      <div class="f_col c1">
        '.em_form_get_select('f_row', 'Type', 'ua_type', '{"add": "Add Assets","min": "Reduce Assets"}').'
        '.em_form_get_select('f_row', 'Select Coin', 'ua_coin', $fin_coin).'
        '.em_form_get_input('f_row', 'Amount', 'number', 'ua_amount', '0.00000000').'
        <input type="hidden" name="ua_id" value="'.$the_users->uid.'">
        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true).'
      </div>
    </div>
  </div>
'); ?>

<?php em_footer_admin(); ?>
