<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Users Mining');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$filter = em_form_get('f'); $search = em_form_get('s'); $user = em_form_get('u');
if($filter){
  if($filter === 'oldest'){
    $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2)";
    $this_page_url = '/em-admin/users/mining/?f=oldest';
    require_once em_public_path('pagenav.php');
    $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2) ORDER BY id ASC LIMIT $start, $page_max");
  } elseif($filter === 'running'){
    $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status = 1";
    $this_page_url = '/em-admin/users/mining/?f=running';
    require_once em_public_path('pagenav.php');
    $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_status = 1 ORDER BY id ASC LIMIT $start, $page_max");
  } elseif($filter === 'finish'){
    $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status = 2";
    $this_page_url = '/em-admin/users/mining/?f=finish';
    require_once em_public_path('pagenav.php');
    $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_status = 2 ORDER BY id ASC LIMIT $start, $page_max");
  } else {
    $co_filter = strtoupper($filter);
    $check_coin = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' WHERE co_symbol = ?');
    $check_coin->execute([$co_filter]); $check_coin = $check_coin->fetch(\PDO::FETCH_OBJ);
    if($check_coin){
      $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_coin = $check_coin->id AND mi_status IN (1, 2)";
      $this_page_url = '/em-admin/users/mining/?f='.$filter;
      require_once em_public_path('pagenav.php');
      $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_coin = $check_coin->id AND mi_status IN (1, 2) ORDER BY id DESC LIMIT $start, $page_max");
    } else {
      $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2)";
      $this_page_url = '/em-admin/users/mining/';
      require_once em_public_path('pagenav.php');
      $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2) ORDER BY id DESC LIMIT $start, $page_max");
    }
  }
} elseif($search){
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_tx LIKE '%$search%' AND mi_status IN (1, 2)";
  $this_page_url = '/em-admin/users/mining/?s='.$search;
  require_once em_public_path('pagenav.php');
  $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_tx LIKE '%$search%' AND mi_status IN (1, 2) ORDER BY id DESC LIMIT $start, $page_max");
} elseif($user){
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_user = $user AND mi_status IN (1, 2)";
  $this_page_url = '/em-admin/users/mining/';
  require_once em_public_path('pagenav.php');
  $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_user = $user AND mi_status IN (1, 2) ORDER BY id DESC LIMIT $start, $page_max");
} else {
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2)";
  $this_page_url = '/em-admin/users/mining/';
  require_once em_public_path('pagenav.php');
  $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_status IN (1, 2) ORDER BY id DESC LIMIT $start, $page_max");
}
$the_deposits->execute(); $the_deposits = $the_deposits->fetchAll(\PDO::FETCH_OBJ);

$the_coins = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' ORDER BY id ASC');
$the_coins->execute(); $the_coins = $the_coins->fetchAll(\PDO::FETCH_OBJ);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row"><?= em_page_title('h2', 'Users Mining', 'user-gear', 'wb nm'); ?></div>
  <?php if($user): echo em_infobox('<p>Mining by: <strong>'.em_get_user($user)->usr_email.'</strong></p>'); endif; ?>
  <div class="ma_row">
    <div class="ma_content">
      <div class="em_filter">
        <form method="get" class="emf_fil">
          <input type="text" name="s" placeholder="Search by Txid" value="<?= $search ? $search : ''; ?>">
        </form>
        <form method="get" class="emf_fil">
          <select name="f" onchange="this.form.submit()" size="1">
            <option value="latest">Latest</option>
            <option value="oldest"<?= $filter && $filter === 'oldest' ? ' selected' : ''; ?>>Oldest</option>
            <option value="running"<?= $filter && $filter === 'running' ? ' selected' : ''; ?>>Running</option>
            <option value="finish"<?= $filter && $filter === 'finish' ? ' selected' : ''; ?>>Finished</option>
            <?php if($the_coins): foreach($the_coins as $coin): ?>
            <option value="<?= strtolower($coin->co_symbol); ?>"<?= $filter && $filter == strtolower($coin->co_symbol) ? ' selected': ''; ?>><?= $coin->co_name.' ('.$coin->co_symbol.')'; ?></option>
            <?php endforeach; endif; ?>
          </select>
        </form>
      </div>
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th rowspan="2">Txid</th>
              <th rowspan="2">User</th>
              <th class="align center" rowspan="2">Coin</th>
              <th rowspan="2">Plan</th>
              <th rowspan="2">Daily Return</th>
              <th class="align center" colspan="2">Duration</th>
              <th rowspan="2" colspan="2">Status</th>
            </tr>
            <tr>
              <th class="align center">Total</th>
              <th class="align center" style="border-right: solid 1px var(--col_outline);">Remaining</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_deposits): foreach($the_deposits as $deposit): ?>
            <tr>
              <td><?= $deposit->mi_tx; ?></td>
              <td><a href="<?= em_admin_url('users/view/?u='.$deposit->mi_user); ?>"><?= substr(em_get_user($deposit->mi_user)->usr_email, 0, 5).'***'; ?></a></td>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $deposit->mi_coin)->co_img); ?>" alt="<?= em_get_coin('id', $deposit->mi_coin)->co_name; ?>"></td>
              <td><?= $deposit->mi_plans; ?></td>
              <td><?= em_con_decimal($deposit->mi_daily).' '.em_get_coin('id', $deposit->mi_coin)->co_symbol; ?></td>
              <td class="align center"><?= $deposit->mi_days; ?> days</td>
              <td class="align center"><?= $deposit->mi_days_left; ?> days</td>
              <td><?= (int)$deposit->mi_status === 1 ? '<span class="tsts s1">Running</span>' : '<span class="tsts s2">Finished</span>'; ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(9); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_deposits){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
