<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('User Lists');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$filter = em_form_get('f'); $search = em_form_get('s');
if($filter){
  if($filter === 'latest'){
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users');
    $this_page_url = '/em-admin/users/?f=latest';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." ORDER BY uid DESC LIMIT $start, $page_max");
  } elseif($filter === 'oldest'){
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users');
    $this_page_url = '/em-admin/users/?f=oldest';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." ORDER BY uid ASC LIMIT $start, $page_max");
  } elseif($filter === 'online'){
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users')." WHERE usr_activity > \"". date('Y-m-d H:i:s', time() - 180) ."\"";
    $this_page_url = '/em-admin/users/?f=online';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." WHERE usr_activity > \"". date('Y-m-d H:i:s', time() - 180) ."\" ORDER BY uid ASC LIMIT $start, $page_max");
  } elseif($filter === 'active'){
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users')." WHERE usr_status = 1";
    $this_page_url = '/em-admin/users/?f=active';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." WHERE usr_status = 1 ORDER BY uid ASC LIMIT $start, $page_max");
  } elseif($filter === 'banned'){
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users')." WHERE usr_status = 2";
    $this_page_url = '/em-admin/users/?f=banned';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." WHERE usr_status = 2 ORDER BY uid ASC LIMIT $start, $page_max");
  } else {
    $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users');
    $this_page_url = '/em-admin/users/';
    require_once em_public_path('pagenav.php');
    $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." ORDER BY usr_admin DESC, uid ASC LIMIT $start, $page_max");
  }
} elseif($search){
  $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users')." WHERE usr_status = 2";
  $this_page_url = '/em-admin/users/?f=banned';
  require_once em_public_path('pagenav.php');
  $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." WHERE CAST(uid AS CHAR) LIKE '%$search%' OR usr_email LIKE '%$search%' OR usr_ip LIKE '%$search%' ORDER BY uid ASC LIMIT $start, $page_max");
} else {
  $nav_query = "SELECT count(uid) AS value FROM ".em_dbtb('users');
  $this_page_url = '/em-admin/users/';
  require_once em_public_path('pagenav.php');
  $the_users = em_db()->prepare("SELECT * FROM ".em_dbtb('users')." ORDER BY usr_admin DESC, uid ASC LIMIT $start, $page_max");
}
$the_users->execute(); $the_users = $the_users->fetchAll(\PDO::FETCH_OBJ);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'User Lists', 'users', 'wb'); ?>
    <div class="ma_content">
      <div class="em_filter">
        <form method="get" class="emf_fil">
          <input type="text" name="s" placeholder="Search by UID
          / Email / IP" value="<?= $search ? $search : ''; ?>">
        </form>
        <form method="get" class="emf_fil">
          <select name="f" onchange="this.form.submit()" size="1">
            <option value="all">Show All</option>
            <option value="latest"<?= $filter && $filter === 'latest' ? ' selected' : ''; ?>>Latest</option>
            <option value="oldest"<?= $filter && $filter === 'oldest' ? ' selected' : ''; ?>>Oldest</option>
            <option value="online"<?= $filter && $filter === 'online' ? ' selected' : ''; ?>>Online</option>
            <option value="active"<?= $filter && $filter === 'active' ? ' selected' : ''; ?>>Active</option>
            <option value="banned"<?= $filter && $filter === 'banned' ? ' selected' : ''; ?>>banned</option>
          </select>
        </form>
      </div>
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th>UID</th>
              <th>Email Address</th>
              <th>Last Activity</th>
              <th>IP Address</th>
              <th colspan="2">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_users): foreach($the_users as $user): ?>
            <tr>
              <td><?= $user->uid; ?></td>
              <td><?= $user->usr_email; ?><?= $user->usr_admin == '15' ? ' <span class="tblk b1">Admin</span>' : ''; ?></td>
              <td><?= em_time_ago($user->usr_activity); ?></td>
              <td><?= $user->usr_ip ? $user->usr_ip : '-'; ?></td>
              <td><?= (int)$user->usr_status < 1 ? '<span class="tsts b0">Inactive</span>' : ((int)$user->usr_status === 1 ? '<span class="tsts s1">Active</span>' : '<span class="tsts s2">Banned</span>'); ?></td>
              <td class="align center"><a href="<?= em_admin_url('users/view/?u='.$user->uid); ?>"><i class="fa-solid fa-pen-to-square"></i></a></td>
            </tr>
            <?php endforeach; else: echo em_table_null(6); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_users){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
