<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('General Settings');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$valid_time = [];
foreach([1800 => 30, 3600 => 60, 7200 => 120] as $time => $m){$valid_time[$time] = str_replace('%m%', $m, '%m% Minutes');}
$fin_valid = json_encode($valid_time, JSON_PRETTY_PRINT);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'System Settings', 'cogs', 'wb nm'); ?>
  </div>
  <div class="ma_row">
    <div class="ma_col r2">
      <div class="ma_row">
        <div class="ma_content">
          <?= em_page_title('h3', 'Authentication', '', 'nm'); ?>
          <div class="em_form">
            <div class="f_data" id="a-2e7SyS/<?= em_form_csrf(); ?>">
              <div class="f_col c1">
                <?= em_form_get_check('f_row', 'Register Status', 'Check if true', 'setsys_reg_status', true, em_config('system.register.status') === true ? ' checked' : ''); ?>
                <input type="hidden" name="setsys_for" value="authset">
                <?= em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="ma_row">
        <div class="ma_content">
          <?= em_page_title('h3', 'Cron Key', '', 'nm'); ?>
          <div class="em_form">
            <?php if(!em_config('system.cron')): ?>
            <div class="f_data" id="a-2e7SyS/<?= em_form_csrf(); ?>">
              <div class="f_col c1">
                <?= em_infobox('<p>Please generate Cron Key to get cron job key.</p>'); ?>
                <input type="hidden" name="setsys_for" value="gencron">
                <?= em_form_get_btn('f_row', 'Generate Cron Key', 'fa-solid fa-stopwatch', false, false); ?>
              </div>
            </div>
            <?php else: ?>
            <div class="f_col c1">
              <?= em_form_get_input('f_row', 'Cron Job Key', 'text', '', em_config('system.cron'), false, true); ?>
              <?= em_form_get_input('f_row', 'Website Day Count Date', 'text', '', em_config('system.runday'), false, true); ?>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Cron Job Settings', '', 'nm'); ?>
      <?php if(!em_config('system.cron')): ?>
      <?= em_infobox('<p>For see the cron job setting, please generate Cron Key first.</p>'); ?>
      <?php else: ?>
      <?= em_infobox('
        <p>Cron Job is very important to reduce the duration of mining every day. Below is the command for your cron job:</p>
        <pre class="s1">Once per day (0 0 * * *)</pre>
        <pre class="s2">/usr/local/bin/php '.$_SERVER['DOCUMENT_ROOT'].'/em-public/api/cron.php "ckey='.em_config('system.cron').'" >> '.$_SERVER['DOCUMENT_ROOT'].'/em-assets/logs/cron.log</pre>
      '); ?>
      <?php endif; ?>
    </div>
  </div>
</div>
<div class="ma_col r2">
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Mailing Settings', '', 'nm'); ?>
      <div class="em_form">
        <div class="f_data" id="a-2e7SyS/<?= em_form_csrf(); ?>">
          <div class="f_col c2">
            <?= em_form_get_select('f_row', 'Request Delay', 'mail_delay', '{"5":"5 Minutes","10":"10 Minutes","15":"15 Minutes"}', em_config('system.mail.delay')); ?>
            <?= em_form_get_select('f_row', 'Vaildation Time', 'mail_vaild', $fin_valid, em_config('system.mail.valid')); ?>
            <?= em_form_get_input('f_row', 'Port', 'text', '', em_config('system.mail.port'), false, true); ?>
            <?= em_form_get_input('f_row', 'Host', 'text', 'mail_host', em_config('system.mail.host')); ?>
            <?= em_form_get_input('f_row', 'Username', 'text', 'mail_name', em_config('system.mail.username')); ?>
            <?= em_form_get_input('f_row', 'Password', 'password', 'mail_pass', em_config('system.mail.password')); ?>
          </div>
          <div class="f_col c1">
            <input type="hidden" name="setsys_for" value="mailset">
            <?= em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Mailing Tester', '', 'nm'); ?>
      <div class="em_form">
        <div class="f_data" id="a-2e7SyS/<?= em_form_csrf(); ?>">
          <div class="f_col c1">
            <?= em_infobox('<p>If your "Mailing Settings" are set correctly, then email message will be sent to the destination address you entered below. If not, the system will respond with a detailed error message.</p>'); ?>
            <?= em_form_get_input('f_row', 'Destination Email', 'text', 'mail_dest'); ?>
            <input type="hidden" name="setsys_for" value="mailtest">
            <?= em_form_get_btn('f_row', 'Send a Test Message', 'fa-solid fa-envelope', false, true); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
