<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Styling Settings');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$font_list = glob(em_index_path('em-assets/font/*')); em_meta_font();
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Styling Settings', 'paint-roller', 'wb'); ?>
    <div class="ma_content">
      <div class="em_form">
        <div class="f_data" id="a-Se72TL/<?= em_form_csrf(); ?>">
          <div class="f_col c3">
            <div class="f_row">
              <div class="f_select">
                <div class="fs_title"><span>Font Style</span><i>*</i></div>
                <select name="st_font">
                  <?php foreach($font_list as $font): if(is_file($font)):
                    $font_basename = basename($font);
                    $font_code = substr($font_basename, 0, strrpos($font_basename, "."));
                    $font_name = str_replace('-', ' ', $font_code); ?>
                  <option value="<?= $font_code; ?>" style="font-family: '<?= ucwords($font_name); ?>', sans-serif!important;"<?= em_config('style.font') == $font_code ? ' selected':''; ?>><?= ucwords($font_name); ?></option>
                  <?php endif; endforeach; ?>
                </select>
              </div>
            </div>
            <?= em_form_get_input('f_row', 'Transition', 'text', 'st_trans', em_config('style.trans')); ?>
            <?= em_form_get_input('f_row', 'Block Radius', 'text', 'st_radius', em_config('style.radius')); ?>
          </div>
          <div class="f_col c2">
            <?= em_form_get_input('f_row', 'Scaled Up', 'text', 'st_scaleu', em_config('style.scaleu')); ?>
            <?= em_form_get_input('f_row', 'Scaled Down', 'text', 'st_scaled', em_config('style.scaled')); ?>
          </div>
          <div class="f_col c3">
            <?= em_form_get_input('f_row', 'Primary Color', 'text', 'col_prim', em_config('style.color.primary')); ?>
            <?= em_form_get_input('f_row', 'Primary Support Color', 'text', 'col_prim_sup', em_config('style.color.primary_sup')); ?>
            <?= em_form_get_input('f_row', 'Primary Text Color', 'text', 'col_prim_text', em_config('style.color.primary_text')); ?>
            <?= em_form_get_input('f_row', 'Second Color', 'text', 'col_secs', em_config('style.color.second')); ?>
            <?= em_form_get_input('f_row', 'Second Support Color', 'text', 'col_secs_sup', em_config('style.color.second_sup')); ?>
            <?= em_form_get_input('f_row', 'Second Text Color', 'text', 'col_secs_text', em_config('style.color.second_text')); ?>
            <?= em_form_get_input('f_row', 'Success Color', 'text', 'col_succ', em_config('style.color.success')); ?>
            <?= em_form_get_input('f_row', 'Success Support Color', 'text', 'col_succ_sup', em_config('style.color.success_sup')); ?>
            <?= em_form_get_input('f_row', 'Success Text Color', 'text', 'col_succ_text', em_config('style.color.success_text')); ?>
            <?= em_form_get_input('f_row', 'Error Color', 'text', 'col_erro', em_config('style.color.error')); ?>
            <?= em_form_get_input('f_row', 'Error Support Color', 'text', 'col_erro_sup', em_config('style.color.error_sup')); ?>
            <?= em_form_get_input('f_row', 'Error Text Color', 'text', 'col_erro_text', em_config('style.color.error_text')); ?>
          </div>
          <div class="f_col c1">
            <?= em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
