<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Finance Settings');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$the_coins = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' ORDER BY id ASC');
$the_coins->execute(); $the_coins = $the_coins->fetchAll(\PDO::FETCH_OBJ);
$coin_json = [];
foreach($the_coins as $coin){$coin_json[$coin->co_symbol] = $coin->co_name.' ('.$coin->co_symbol.')';}
$fin_coin = json_encode($coin_json, JSON_PRETTY_PRINT);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Finance Settings', 'building-columns', 'wb'); ?>
    <div class="ma_content">
      <div class="em_form">
        <div class="f_data" id="a-2EtF1N/<?= em_form_csrf(); ?>">
          <div class="f_col c1">
            <?= em_page_title('h3', 'HSPay', '', 'wb nm'); ?>
            <div class="f_col c2">
              <?= em_form_get_input('f_row', 'Faucet API', 'text', 'hp_fapi', em_config('finance.hspay.faucet_api')); ?>
              <?= em_form_get_input('f_row', 'Merchant API', 'text', 'hp_mapi', em_config('finance.hspay.merchant_api')); ?>
              <?= em_form_get_check('f_row', 'Deposit Status', 'Check if true', 'hp_dpsts', true, em_config('finance.hspay.depo_status') ? ' checked' : ''); ?>
              <?= em_form_get_check('f_row', 'Auto Withdrawals', 'Check if true', 'hp_auwd', true, em_config('finance.hspay.wd_auto') ? ' checked' : ''); ?>
            </div>
            <?= em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Free Plan Settings', '', 'wb nm'); ?>
      <?= em_infobox('<span>Give free mining rewards to newly registered users, can also be disabled by unchecking the form below.</span>'); ?>
      <div class="em_form">
        <div class="f_data" id="a-Fr3P1n/<?= em_form_csrf(); ?>">
          <div class="f_col c1">
            <?= em_form_get_check('f_row', 'Free Plan Status', 'Check if true', 'free_status', true, em_config('finance.free_plan.status') ? ' checked' : ''); ?>
          </div>
          <div class="f_col c2">
            <?= em_form_get_input('f_row', 'Plan Name', 'text', 'free_name', em_config('finance.free_plan.name')); ?>
            <?= em_form_get_select('f_row', 'Plan Coin', 'free_coin', $fin_coin, em_config('finance.free_plan.coin')); ?>
            <?= em_form_get_input('f_row', 'Duration (days)', 'number', 'free_dur', em_config('finance.free_plan.duration')); ?>
            <?= em_form_get_input('f_row', 'Daily Return', 'number', 'free_daily', em_config('finance.free_plan.daily')); ?>
          </div>
          <div class="f_col c1">
            <?= em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
