<?php ob_start("em_theme_minified"); ?>
<!DOCTYPE html>
<html lang="en-US">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="robots" content="noindex, nofollow" />
  <title>Admin: <?= $set_title ?> - <?= em_config('site.name'); ?></title>
  <meta name="description" content="<?= em_config('site.desc'); ?>" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" sizes="32x32" />
  <link rel="icon" type="image/png" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" sizes="192x192" />
  <link rel="apple-touch-icon" href="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <meta name="msapplication-TileImage" content="<?= em_asset_url('img/brand/'.em_config('site.icon')); ?>" />
  <link rel="stylesheet" href="<?= em_asset_url('font/'.em_config('style.font').'.css?v=1.0.0'); ?>" />
  <link rel="stylesheet" href="<?= em_asset_url('css/em_admin_style.css?v='.em_script_ver()); ?>" />
  <script type="text/javascript" src="<?= em_asset_url('js/em_bundle.js?v=3.7.1'); ?>"></script>
  <style type="text/css"><?= em_custom_css(); ?></style>
</head>
<body em-theme="dark" em-base="<?= em_site_url(); ?>" id="emerel-cms"><ppbreak/>
<div class="em_root">
  <div class="em_head">
    <div class="eh_brand">
      <div class="ehb_logo">
        <img src="<?= em_asset_url('img/brand/'.em_config('site.logo')); ?>" width="120" height="40" title="<?= em_config('site.name'); ?>">
        <span>Admin Panel</span>
      </div>
      <div class="ehb_mob_menu"><i class="fa-solid fa-bars-staggered"></i></div>
    </div>
    <div class="eh_menu">
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url(); ?>" hm-page="dash" title="Dashboard"><i class="fa-solid fa-gauge"></i><span>Dashboard</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_site_url('dash/'); ?>" hm-page="upage" title="Back to User Page"><i class="fa-solid fa-arrow-left"></i><span>Goto User Page</span></a></div>

      <div class="ehm_group"><span>Financial</span></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('finance/deposits/'); ?>" hm-page="deposits" title="Deposits"><i class="fa-solid fa-cash-register"></i><span>Deposits</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('finance/withdrawals/'); ?>" hm-page="withdrawals" title="Withdrawals"><i class="fa-solid fa-wallet"></i><span>Withdrawals</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('finance/earnings/'); ?>" hm-page="earnings" title="Earnings"><i class="fa-solid fa-rectangle-list"></i><span>Earnings</span></a></div>

      <div class="ehm_group"><span>Features</span></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('mining/'); ?>" hm-page="mining" title="Mining Plans"><i class="fa-solid fa-microchip"></i><span>Mining Plans</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('coins/'); ?>" hm-page="coins" title="Coin Lists"><i class="fa-solid fa-coins"></i><span>Coin Lists</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('users/'); ?>" hm-page="users" title="User Lists"><i class="fa-solid fa-users"></i><span>User Lists</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('users/mining/'); ?>" hm-page="user-mining" title="User Mining"><i class="fa-solid fa-user-gear"></i><span>User Mining</span></a></div>

      <div class="ehm_group"><span>Settings</span></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('settings/'); ?>" hm-page="settings" title="General Settings"><i class="fa-solid fa-gear"></i><span>General</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('settings/system/'); ?>" hm-page="system" title="Systems Settings"><i class="fa-solid fa-gears"></i><span>System</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('settings/finance/'); ?>" hm-page="finance" title="Finance Settings"><i class="fa-solid fa-building-columns"></i><span>Finance</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('settings/styling/'); ?>" hm-page="styling" title="Styling Settings"><i class="fa-solid fa-paint-roller"></i><span>Styling</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('settings/layouts/'); ?>" hm-page="layouts" title="Layouts Settings"><i class="fa-solid fa-table-cells-large"></i><span>Layouts</span></a></div>

      <div class="ehm_group"><span>Miscellaneous</span></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('misc/errors/'); ?>" hm-page="errors" title="Errors Logs"><i class="fa-solid fa-bug"></i><span>Errors Log</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('misc/warning/'); ?>" hm-page="warning" title="Warning Logs"><i class="fa-solid fa-triangle-exclamation"></i><span>Warning Logs</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('misc/cron/'); ?>" hm-page="cron" title="Cron Logs"><i class="fa-solid fa-stopwatch"></i><span>Cron Logs</span></a></div>
      <div class="ehm_item"><a class="ehmi_link" href="<?= em_admin_url('misc/systems/'); ?>" hm-page="systems" title="Systems Check"><i class="fa-solid fa-square-check"></i><span>Systems Check</span></a></div>
    </div>
  </div>
  <div class="em_main">
