<?php require_once __DIR__ .'/../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Mining Plans');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$filter = em_form_get('f');
if($filter && $filter !== 'all'){
  $the_mining = em_db()->prepare('SELECT * FROM '.em_dbtb('mining_plans').' WHERE mp_coin = ? ORDER BY id ASC');
  $the_mining->execute([$filter]); $the_mining = $the_mining->fetchAll(\PDO::FETCH_OBJ);
} else {
  $the_mining = em_db()->prepare('SELECT * FROM '.em_dbtb('mining_plans').' ORDER BY id ASC');
  $the_mining->execute(); $the_mining = $the_mining->fetchAll(\PDO::FETCH_OBJ);
}

$the_coins = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' ORDER BY id ASC');
$the_coins->execute(); $the_coins = $the_coins->fetchAll(\PDO::FETCH_OBJ);
$coin_json = [];
foreach($the_coins as $coin){$coin_json[$coin->id] = $coin->co_name.' ('.$coin->co_symbol.')';}
$fin_coin = json_encode($coin_json, JSON_PRETTY_PRINT);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Mining Plans', 'microchip', 'wb'); ?>
    <div class="ma_content">
      <div class="em_filter">
        <form method="get" class="emf_fil">
          <select name="f" onchange="this.form.submit()" size="1">
            <option value="all">Show All</option>
            <?php if($the_coins): foreach($the_coins as $coin): ?>
            <option value="<?= $coin->id; ?>"<?= $filter && $filter == $coin->id ? ' selected': ''; ?>><?= $coin->co_name.' ('.$coin->co_symbol.')'; ?></option>
            <?php endforeach; endif; ?>
          </select>
        </form>
        <div class="emf_btn em_modal_btn" for-mod="add_plan"><i class="fa-solid fa-square-plus"></i><span>Add Plan</span></div>
      </div>
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th class="align center">Coin</th>
              <th>Plan Name</th>
              <th>Price / Deposit</th>
              <th>Duration</th>
              <th colspan="3">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_mining): foreach($the_mining as $mining): ?>
            <tr>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $mining->mp_coin)->co_img); ?>" alt="<?= em_get_coin('id', $mining->mp_coin)->co_name; ?>"></td>
              <td><?= $mining->mp_name; ?></td>
              <td><?= em_pure_con_decimal($mining->mp_deposit); ?></td>
              <td><?= count(em_dbjson($mining->mp_specs)); ?> Options</td>
              <td><?= (int)$mining->mp_status === 1 ? '<span class="tsts s1">Active</span>' : '<span class="tsts s2">Inactive</span>'; ?></td>
              <td class="align center">
                <a class="em_modal_btn" for-mod="edit_plan_<?= $mining->id; ?>"><i class="fa-solid fa-pen-to-square"></i></a>
                <?= em_modal('edit_plan_'.$mining->id, 'Edit '.$mining->mp_name.' ('.em_get_coin('id', $mining->mp_coin)->co_symbol.')', '
                  <div class="em_form">
                    <div class="f_data" id="a-Ed7PLN/'.em_form_csrf().'">
                      <div class="f_col c1">
                        '.em_form_get_select('f_row', 'Plan Coin', '', $fin_coin, $mining->mp_coin, false, true).'
                        '.em_form_get_input('f_row', 'Plan Name', 'text', 'plan_name', $mining->mp_name).'
                        '.em_form_get_input('f_row', 'Price / Deposit', 'number', 'plan_deposit', $mining->mp_deposit).'
                        '.em_form_get_plans('f_row', 'Specifications', '["Duration", "Daily Return"]', '["plan_dur", "plan_daily"]', $mining->mp_specs).'
                        '.em_form_get_check('f_row', 'Status', 'Check if true', 'plan_status', true, (int)$mining->mp_status === 1 ? ' checked' : '').'
                        <input type="hidden" name="plan_id" value="'.$mining->id.'">
                        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-square-plus', false, true).'
                      </div>
                    </div>
                  </div>
                '); ?>
              </td>
              <td class="align center">
                <a class="em_modal_btn" for-mod="del_plan_<?= $mining->id; ?>"><i class="fa-solid fa-trash"></i></a>
                <?= em_modal('del_plan_'.$mining->id, 'Delete '.$mining->mp_name.' ('.em_get_coin('id', $mining->mp_coin)->co_symbol.')', '
                  '.em_infobox('<p>Deleted mining plans cannot be restored, all users have this mining plan will not be affected by this deletion.</p>').'
                  <div class="em_form">
                    <div class="f_data" id="a-d3Lp1N/'.em_form_csrf().'">
                      <div class="f_col c1">
                        '.em_form_get_check('f_row', 'Validation', 'Agree and Delete', 'plan_delete', true).'
                        <input type="hidden" name="plan_id" value="'.$mining->id.'">
                        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-trash', false, true).'
                      </div>
                    </div>
                  </div>
                '); ?>
              </td>
            </tr>
            <?php endforeach; else: echo em_table_null(7); endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?= em_modal('add_plan', 'Add Mining Plan', '
  <div class="em_form">
    <div class="f_data" id="a-4AdP1n/'.em_form_csrf().'">
      <div class="f_col c1">
        '.em_form_get_select('f_row', 'Plan Coin', 'plan_coin', $fin_coin).'
        '.em_form_get_input('f_row', 'Plan Name', 'text', 'plan_name').'
        '.em_form_get_input('f_row', 'Price / Deposit', 'number', 'plan_deposit').'
        '.em_form_get_plans('f_row', 'Specifications', '["Duration", "Daily Return"]', '["plan_dur", "plan_daily"]').'
        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-square-plus', false, true).'
      </div>
    </div>
  </div>
'); ?>

<?php em_footer_admin(); ?>
