<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Earnings');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$uid = em_form_get('user');
if(!$uid){
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('earnings');
  $this_page_url = '/em-admin/finance/earnings/';
  require_once em_public_path('pagenav.php');
  $the_earnings = em_db()->prepare("SELECT * FROM ".em_dbtb('earnings')." ORDER BY id DESC LIMIT $start, $page_max");
  $the_earnings->execute(); $the_earnings = $the_earnings->fetchAll(\PDO::FETCH_OBJ);
} else {
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('earnings');
  $this_page_url = '/em-admin/finance/earnings/?user='.$uid;
  require_once em_public_path('pagenav.php');
  $the_earnings = em_db()->prepare("SELECT * FROM ".em_dbtb('earnings')." WHERE ea_user = ? ORDER BY id DESC LIMIT $start, $page_max");
  $the_earnings->execute([$uid]); $the_earnings = $the_earnings->fetchAll(\PDO::FETCH_OBJ);
}
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row"><?= em_page_title('h2', 'Earnings', 'rectangle-list', 'wb nm'); ?></div>
  <?php if($uid): ?>
  <?= em_infobox('<p>Earnings by: <strong>'.em_get_user($uid)->usr_email.'</strong></p>'); ?>
  <?php endif; ?>
  <div class="ma_row">
    <div class="ma_content">
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th class="align center">#ID</th>
              <th>User</th>
              <th class="align center">Coin</th>
              <th>Info</th>
              <th>Mining ID</th>
              <th>Value</th>
              <th>Date Time</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_earnings): foreach($the_earnings as $earning): ?>
            <tr>
              <td class="align center">#<?= $earning->id; ?></td>
              <td><a href="<?= em_admin_url('users/view/?u='.$earning->ea_user); ?>"><?= substr(em_get_user($earning->ea_user)->usr_email, 0, 5).'***'; ?></a></td>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $earning->ea_coin)->co_img); ?>" alt="<?= em_get_coin('id', $earning->ea_coin)->co_name; ?>"></td>
              <td><?= em_earn_info($earning->ea_info); ?></td>
              <td><?= $earning->ea_mining ? $earning->ea_mining : '-'; ?></td>
              <td><?= em_con_decimal($earning->ea_value); ?> <?= em_get_coin('id', $earning->ea_coin)->co_symbol; ?></td>
              <td><?= em_time_full($earning->ea_date); ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(7); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_earnings){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
