<?php require_once __DIR__ .'/../../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Deposits');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$uid = em_form_get('user');
if(!$uid){
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_status != 0";
  $this_page_url = '/em-admin/finance/deposits/';
  require_once em_public_path('pagenav.php');
  $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_depo_mtd != ? AND mi_status != 0 ORDER BY id DESC LIMIT $start, $page_max");
  $the_deposits->execute(['free']); $the_deposits = $the_deposits->fetchAll(\PDO::FETCH_OBJ);

  $pend_deposit = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_depo_mtd != ? AND mi_status = 0 ORDER BY id DESC");
  $pend_deposit->execute(['free']); $pend_deposit = $pend_deposit->fetchAll(\PDO::FETCH_OBJ);
} else {
  $nav_query = "SELECT count(id) AS value FROM ".em_dbtb('mining')." WHERE mi_depo_mtd != 'free' AND mi_status != 0";
  $this_page_url = '/em-admin/finance/deposits/?user='.$uid;
  require_once em_public_path('pagenav.php');
  $the_deposits = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_user = ? AND mi_depo_mtd != ? AND mi_status != 0 ORDER BY id DESC LIMIT $start, $page_max");
  $the_deposits->execute([$uid, 'free']); $the_deposits = $the_deposits->fetchAll(\PDO::FETCH_OBJ);

  $pend_deposit = em_db()->prepare("SELECT * FROM ".em_dbtb('mining')." WHERE mi_user = ? AND mi_depo_mtd != ? AND mi_status = 0 ORDER BY id DESC");
  $pend_deposit->execute([$uid, 'free']); $pend_deposit = $pend_deposit->fetchAll(\PDO::FETCH_OBJ);
}
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row"><?= em_page_title('h2', 'Deposits', 'cash-register', 'wb nm'); ?></div>
  <?php if($uid): ?>
  <?= em_infobox('<p>Deposits by: <strong>'.em_get_user($uid)->usr_email.'</strong></p>'); ?>
  <?php endif; if($pend_deposit): ?>
  <div class="ma_row">
    <div class="ma_content">
      <?= em_page_title('h3', 'Pending Deposits', '', 'nm'); ?>
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th>Txid</th>
              <th>User</th>
              <th class="align center">Coin</th>
              <th>Info</th>
              <th>Value</th>
              <th colspan="2">Method</th>
            </tr>
          </thead>
          <tbody>
            <?php if($pend_deposit): foreach($pend_deposit as $deposit): ?>
            <tr>
              <td><?= $deposit->mi_tx; ?></td>
              <td><a href="<?= em_admin_url('users/view/?u='.$deposit->mi_user); ?>"><?= substr(em_get_user($deposit->mi_user)->usr_email, 0, 5).'***'; ?></a></td>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $deposit->mi_coin)->co_img); ?>" alt="<?= em_get_coin('id', $deposit->mi_coin)->co_name; ?>"></td>
              <td><?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?> Mining (<?= $deposit->mi_plans; ?>)</td>
              <td><?= em_con_decimal($deposit->mi_deposit); ?> <?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?></td>
              <td><?= em_depo_method($deposit->mi_depo_mtd); ?></td>
              <td class="align center">
                <a class="em_modal_btn" for-mod="edit_depo_<?= $deposit->id; ?>"><i class="fa-solid fa-pen-to-square"></i></a>
                <?= em_modal('edit_depo_'.$deposit->id, $deposit->mi_tx, '
                  '.em_infobox('<p>Use this function if the user has provided proof of payment but the system does not respond to it so mark this <strong>"Paid"</strong>. In other cases, the system may let the deposit not proceed within 24 hours, so use this to mark <strong>"Reject"</strong> for deposits that are not proceed after 24 hours.</p>').'
                  <div class="em_form">
                    <div class="f_data" id="a-D3p0Ac/'.em_form_csrf().'">
                      <div class="f_col c1">
                        '.em_form_get_select('f_row', 'Tagging', 'depo_act', '{"accept": "Mark as paid", "reject": "Mark as Reject"}').'
                        <input type="hidden" name="depo_id" value="'.$deposit->id.'">
                        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, false).'
                      </div>
                    </div>
                  </div>
                '); ?>
              </td>
            </tr>
            <?php endforeach; else: echo em_table_null(7); endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php endif; ?>
  <div class="ma_row">
    <div class="ma_content">
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th>Txid</th>
              <th>User</th>
              <th class="align center">Coin</th>
              <th>Info</th>
              <th>Value</th>
              <th>Method</th>
              <th>Date Time</th>
              <th class="align center">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_deposits): foreach($the_deposits as $deposit): ?>
            <tr>
              <td><?= $deposit->mi_tx; ?></td>
              <td><a href="<?= em_admin_url('users/view/?u='.$deposit->mi_user); ?>"><?= substr(em_get_user($deposit->mi_user)->usr_email, 0, 5).'***'; ?></a></td>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.em_get_coin('id', $deposit->mi_coin)->co_img); ?>" alt="<?= em_get_coin('id', $deposit->mi_coin)->co_name; ?>"></td>
              <td><?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?> Mining (<?= $deposit->mi_plans; ?>)</td>
              <td><?= em_con_decimal($deposit->mi_deposit); ?> <?= em_get_coin('id', $deposit->mi_coin)->co_symbol; ?></td>
              <td><?= em_depo_method($deposit->mi_depo_mtd); ?></td>
              <td><?= em_time_full($deposit->mi_date); ?></td>
              <td class="align center"><?= $deposit->mi_status < 1 ? '<span class="tsts">Unpaid</span>' : ($deposit->mi_status > 2 ? '<span class="tsts s2">Ignored</span>' : '<span class="tsts s1">Paid</span>'); ?></td>
            </tr>
            <?php endforeach; else: echo em_table_null(8); endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($the_deposits){echo $emerel_pagenav;} ?>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
