<?php require_once __DIR__ .'/../em-app/handler.php'; em_user()->user_admin();
em_header_admin('Coin Lists');
//////////////////////////////////////////////////////////////////////////////
/// Create by Emerel.xyz
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
$the_coins = em_db()->prepare('SELECT * FROM '.em_dbtb('coins').' ORDER BY id ASC');
$the_coins->execute(); $the_coins = $the_coins->fetchAll(\PDO::FETCH_OBJ);
////////////////////////// CUSTOM FUNCTIONS /////////////////////////////////
?>

<div class="ma_col r1">
  <div class="ma_row">
    <?= em_page_title('h2', 'Coin Lists', 'coins', 'wb'); ?>
    <div class="ma_content">
      <div class="em_table">
        <table>
          <thead>
            <tr>
              <th class="align center" rowspan="2">#</th>
              <th rowspan="2">Name</th>
              <th class="align center" colspan="3">Withdraw</th>
              <th class="align center" rowspan="2">Deposit</th>
              <th rowspan="2" colspan="2">Status</th>
            </tr>
            <tr>
              <th class="align center">Minimum</th>
              <th class="align center">Fees</th>
              <th class="align center" style="border-right: solid 1px var(--col_outline);">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php if($the_coins): foreach($the_coins as $coin): ?>
            <tr>
              <td class="align center"><img src="<?= em_asset_url('img/coin/'.$coin->co_img); ?>" alt="<?= $coin->co_name; ?>"></td>
              <td><?= $coin->co_name; ?> (<?= $coin->co_symbol; ?>)</td>
              <td class="align center"><?= em_pure_con_decimal($coin->co_wd_min); ?></td>
              <td class="align center"><?= em_pure_con_decimal($coin->co_wd_fee); ?></td>
              <td class="align center"><?= (int)$coin->co_wd_status === 1 ? '<span class="tsts s1">Active</span>' : '<span class="tsts s2">Inactive</span>'; ?></td>
              <td class="align center"><?= (int)$coin->co_depo_status === 1 ? '<span class="tsts s1">Active</span>' : '<span class="tsts s2">Inactive</span>'; ?></td>
              <td><?= (int)$coin->co_status === 1 ? '<span class="tsts s1">Active</span>' : '<span class="tsts s2">Inactive</span>'; ?></td>
              <td class="align center">
                <a class="em_modal_btn" for-mod="edit_coin_<?= $coin->id; ?>"><i class="fa-solid fa-pen-to-square"></i></a>
                <?= em_modal('edit_coin_'.$coin->id, 'Edit '.$coin->co_symbol, '
                  <div class="em_form">
                    <form class="f_data_media" id="a-Ed7C0n/'.em_form_csrf().'" enctype="multipart/form-data">
                      <div class="f_col c1">
                        '.em_form_get_upload('f_row', 'Coin Logo', 'Recommended size 250x250 pixels, only accepts PNG files.', 'coin_img', 'image/png', em_asset_url('img/coin/'.$coin->co_img), 1).'
                        '.em_form_get_input('f_row', 'Coin Name', 'text', 'coin_name', $coin->co_name).'
                        '.em_form_get_input('f_row', 'Withdraw Minimum', 'number', 'coin_wd_min', $coin->co_wd_min).'
                        '.em_form_get_input('f_row', 'Withdraw Fees', 'number', 'coin_wd_fee', $coin->co_wd_fee).'
                        '.em_form_get_check('f_row', 'Withdraw Status', 'Check if true', 'coin_wd_status', true, (int)$coin->co_wd_status === 1 ? ' checked' : '').'
                        '.em_form_get_check('f_row', 'Deposit Status', 'Check if true', 'coin_depo_status', true, (int)$coin->co_depo_status === 1 ? ' checked' : '').'
                        '.em_form_get_check('f_row', 'Global Status', 'Check if true', 'coin_status', true, (int)$coin->co_status === 1 ? ' checked' : '').'
                        <input type="hidden" name="coin_id" value="'.$coin->id.'">
                        '.em_form_get_btn('f_row', 'Submit', 'fa-solid fa-pen-to-square', false, true).'
                      </div>
                    </form>
                  </div>
                '); ?>
              </td>
            </tr>
            <?php endforeach; else: echo em_table_null(8); endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php em_footer_admin(); ?>
