-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Nov 03, 2025 at 02:28 AM
-- Server version: 10.11.14-MariaDB
-- PHP Version: 8.4.13

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `demominescript_dem`
--

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `email` varchar(125) NOT NULL,
  `username` varchar(125) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(125) NOT NULL,
  `two_factor_method` enum('none','email','app') NOT NULL DEFAULT 'none',
  `two_factor_token` varchar(125) DEFAULT NULL,
  `google2fa_secret` text DEFAULT NULL,
  `avatar` varchar(125) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `name`, `email`, `username`, `email_verified_at`, `password`, `two_factor_method`, `two_factor_token`, `google2fa_secret`, `avatar`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 'Administrator', 'MAILFROM', 'admin', '2025-11-02 11:09:52', '$2y$10$102LETHfYnnxweFHZmPraOm5I4qBVnrHax2Z5Lux26dGxoSGV4wEi', 'none', NULL, NULL, NULL, 'ZlDLPs4vvws3VvgbPqz4Lqhveu01cwiksa4lO6m8V0FUZTwsyQgeGI2jry9w', '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `deposits`
--

CREATE TABLE `deposits` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `invoice` varchar(125) NOT NULL,
  `invoice_expire_date` timestamp NULL DEFAULT NULL,
  `power` decimal(15,2) NOT NULL,
  `amount` decimal(30,15) NOT NULL,
  `paid_amount` decimal(30,15) DEFAULT NULL,
  `tx_id` varchar(125) DEFAULT NULL,
  `status` enum('pending','processing','paid','canceled') NOT NULL DEFAULT 'pending',
  `cancel_reason` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `qrcode` text DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `deposits`
--

INSERT INTO `deposits` (`id`, `user_id`, `invoice`, `invoice_expire_date`, `power`, `amount`, `paid_amount`, `tx_id`, `status`, `cancel_reason`, `response`, `qrcode`, `comments`, `created_at`, `updated_at`) VALUES
(1, 1, '4HoSkJ9Z95j5OEz1', NULL, 1.00, 0.000000010000000, NULL, NULL, 'pending', NULL, NULL, NULL, NULL, '2025-11-02 14:26:52', '2025-11-02 14:26:52'),
(2, 1, 'HtHDIiqFVpckgdwz', NULL, 1.00, 0.000000010000000, NULL, NULL, 'pending', NULL, '{\n    \"status\": 200,\n    \"error\": false,\n    \"message\": \"ok\",\n    \"data\": {\n        \"pay_url\": \"https:\\/\\/hspay.io\\/merchant\\/?pay=LddSRzByNjKGkXy9LyCvkt4y152BM319VbvuahPezIBVLiYvGX5w795obCewLlAoX2C60tLHpdcty4mghJvRCAEU1QuHtkrwLg6GCbiguvAXvHaN2rsAOLu3otsB-CWE_U850-UsXt1Ks1Op4dONI69V7SduUZWzSmSvNH_hezOd15jgbz7_HlXgdBPDoMmI2EKOfmF1wCcDoquQbdALALdka8EOInVMoCR9MVXhomn_xMckFBI-Le0RNHrOFwJqGu4EjzJBppSt2rUPOamYb6-P5ehW1lNstcQ0iyuvERx5Q145XqSQNtXBJKUXLN3plK8Qz7Sre6y074JbNp5sR83F7EqZH9EJQC2UspJAGkkdpDWR9YAWdUI0g2H8jGSksidHg2SajZ2mhI_ZwhuyT_-h-H4QvM5Cy7W4wWUeBbcxZ7ZVPGM0w2gNFuvubliwbQtP66a1XobfAOPMMPMXG9UPYLOuHSBqnBfg7B-Yhrp78x_hS_KLYowqPDAsoTLdvN1DPAds3IBcwFGA2rm_RluqL0QNiueUSM81_3LW-Hw\"\n    }\n}', NULL, NULL, '2025-11-02 14:47:33', '2025-11-02 14:47:37'),
(3, 2, 'SxajexmvsIXajhj6', NULL, 1.00, 0.000000010000000, NULL, NULL, 'pending', NULL, '{\n    \"status\": 200,\n    \"error\": false,\n    \"message\": \"ok\",\n    \"data\": {\n        \"pay_url\": \"https:\\/\\/hspay.io\\/merchant\\/?pay=wmZc6kGKfW90uHFHH7F3KeRuE5RFuM8cyqLygKa_V_VX3QG8KRsosabS-dLCQwWt8gQ0mU8-NRPdUysiNpxvEzATLYyTkVNpSo0J5FO3gU-a1NPkBPQIWwh5qlUQPd8pVf8SlvrKkfIDp71qKvA3HpOjnlkl5TjyJI-LPvn4nWH7Fr-cAVAuiKZAdudNGtlqmtpQCHMMnAyaoiFe9wleh9LisoNB_2S_O3jrHaW--7-nGtduetI-s5-rFNTdwmwy_TYmEIXgbc3kk3yIyJ1uo_7fjF1NJ1OcM9hvbAgYH2_TQ2dlzh96hOQOtn_CHrMUZ_HJIJ8azfM6KlVILD03ppd5c6xKIjEKbQ8UczlJtteWLt4i9Pa1eMzePbE3K7X1PPILPbUad6qm31RI-c0icOGwkYxiLxrxwgUddj1xtgwlqSGA2E6nNMSjJxZ2TrXWcpzu0bGH6K2fNbZ_1M0y1h0RKRBcx_nPy0Cm2nrLCQemmPvtJUvC4Nh0Sv8-sCDqOGvbTh1pI2gJ1zSmKfxiCW73JfU43QcMk4CWN34ySMA\"\n    }\n}', NULL, NULL, '2025-11-02 14:55:19', '2025-11-02 14:55:19');

-- --------------------------------------------------------

--
-- Table structure for table `error_logs`
--

CREATE TABLE `error_logs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `type` enum('deposit','withdrawal','others') NOT NULL DEFAULT 'others',
  `message` text NOT NULL,
  `deposit_id` bigint(20) UNSIGNED DEFAULT NULL,
  `withdrawal_id` bigint(20) UNSIGNED DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(125) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `faqs`
--

CREATE TABLE `faqs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `question` varchar(125) NOT NULL,
  `answer` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(125) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2017_08_24_000000_create_settings_table', 1),
(4, '2019_08_19_000000_create_failed_jobs_table', 1),
(5, '2021_04_17_200227_create_permission_tables', 1),
(6, '2021_04_17_201007_create_sessions_table', 1),
(7, '2021_04_17_201907_create_password_resets_admins', 1),
(8, '2021_04_17_213925_create_admins_table', 1),
(9, '2021_04_21_194304_create_pages_table', 1),
(10, '2021_09_21_001637_create_user_mining_powers_table', 1),
(11, '2021_09_21_004651_create_deposits_table', 1),
(12, '2021_09_21_004704_create_withdrawals_table', 1),
(13, '2021_09_21_004809_create_error_logs_table', 1),
(14, '2021_09_21_004845_create_user_logs_table', 1),
(15, '2021_10_10_223735_create_faqs_table', 1),
(16, '2021_10_11_182804_create_news_table', 1),
(17, '2021_10_15_225841_create_ticket_categories_table', 1),
(18, '2021_10_15_230112_create_ticket_statuses_table', 1),
(19, '2021_10_15_230216_create_ticket_priorities_table', 1),
(20, '2021_10_15_230520_create_tickets_table', 1),
(21, '2021_10_15_230722_create_ticket_comments_table', 1),
(22, '2021_12_01_001951_update_withdrawal_fee_column', 1);

-- --------------------------------------------------------

--
-- Table structure for table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(125) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(125) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\Admin', 1);

-- --------------------------------------------------------

--
-- Table structure for table `news`
--

CREATE TABLE `news` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(125) NOT NULL,
  `content` longtext NOT NULL,
  `status` enum('published','draft') NOT NULL DEFAULT 'draft',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `slug` varchar(125) NOT NULL,
  `content` longtext NOT NULL,
  `meta_keywords` varchar(125) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `status` enum('published','draft') NOT NULL DEFAULT 'draft',
  `type` enum('tos','privacy','page') NOT NULL DEFAULT 'page',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` (`id`, `name`, `slug`, `content`, `meta_keywords`, `meta_description`, `status`, `type`, `created_at`, `updated_at`) VALUES
(1, 'Terms of Service', 'terms-of-service', '<p>Terms of service page content here</p>', NULL, NULL, 'published', 'tos', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(2, 'Privacy Policy', 'privacy-policy', '<p>Privacy policy page content here</p>', NULL, NULL, 'published', 'privacy', '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(125) NOT NULL,
  `token` varchar(125) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets_admins`
--

CREATE TABLE `password_resets_admins` (
  `email` varchar(125) NOT NULL,
  `token` varchar(125) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `guard_name` varchar(125) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'list-roles', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(2, 'create-roles', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(3, 'edit-roles', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(4, 'delete-roles', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(5, 'list-permissions', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(6, 'create-permissions', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(7, 'edit-permissions', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(8, 'delete-permissions', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(9, 'list-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(10, 'create-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(11, 'edit-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(12, 'delete-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(13, 'impersonate-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(14, 'list-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(15, 'create-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(16, 'edit-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(17, 'delete-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(18, 'impersonate-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(19, 'list-pages', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(20, 'create-pages', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(21, 'edit-pages', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(22, 'delete-pages', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(23, 'list-settings', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(24, 'edit-settings', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(25, 'list-withdrawals', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(26, 'edit-withdrawals', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(27, 'delete-withdrawals', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(28, 'pay-withdrawal-requests', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(29, 'list-deposits', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(30, 'edit-deposits', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(31, 'delete-deposits', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(32, 'list-news', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(33, 'create-news', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(34, 'edit-news', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(35, 'delete-news', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(36, 'list-faqs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(37, 'create-faqs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(38, 'edit-faqs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(39, 'delete-faqs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(40, 'list-ticket-status', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(41, 'create-ticket-status', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(42, 'edit-ticket-status', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(43, 'delete-ticket-status', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(44, 'list-ticket-priorities', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(45, 'create-ticket-priorities', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(46, 'edit-ticket-priorities', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(47, 'delete-ticket-priorities', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(48, 'list-ticket-categories', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(49, 'create-ticket-categories', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(50, 'edit-ticket-categories', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(51, 'delete-ticket-categories', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(52, 'list-tickets', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(53, 'edit-tickets', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(54, 'delete-tickets', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(55, 'update-script', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(56, 'show-roles', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(57, 'show-permissions', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(58, 'show-users', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(59, 'show-admins', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(60, 'show-pages', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(61, 'show-settings', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(62, 'show-withdrawals', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(63, 'show-deposits', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(64, 'show-news', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(65, 'show-faqs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(66, 'show-ticket-status', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(67, 'show-ticket-priorities', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(68, 'show-ticket-categories', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(69, 'show-tickets', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(70, 'list-error-logs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(71, 'show-error-logs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(72, 'delete-error-logs', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `guard_name` varchar(125) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
(1, 'Super Admin', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(2, 'Admin', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(3, 'Demo', 'admin', '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 1),
(1, 3),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(5, 3),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(9, 2),
(9, 3),
(10, 1),
(10, 2),
(11, 1),
(11, 2),
(12, 1),
(12, 2),
(13, 1),
(13, 2),
(14, 1),
(14, 3),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(19, 1),
(19, 2),
(19, 3),
(20, 1),
(20, 2),
(21, 1),
(21, 2),
(22, 1),
(22, 2),
(23, 1),
(23, 3),
(24, 1),
(25, 1),
(26, 1),
(27, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(32, 1),
(33, 1),
(34, 1),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(41, 1),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(47, 1),
(48, 1),
(49, 1),
(50, 1),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 1),
(56, 1),
(57, 1),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(66, 1),
(67, 1),
(68, 1),
(69, 1),
(70, 1),
(71, 1),
(72, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(125) NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `key` varchar(125) NOT NULL,
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `key`, `value`) VALUES
(1, 'site_name', 'APPNAME'),
(2, 'admin_pagination', '10'),
(3, 'site_pagination', '10'),
(4, 'default_editor', 'summernote'),
(5, 'default_alerts', 'toastr'),
(6, 'frontend_theme', 'default'),
(7, 'dashboard_theme', 'default'),
(8, 'frontend_statistics', '0'),
(9, 'maintenance_status', 'inactive'),
(10, 'cookie_consent_status', 'no'),
(11, 'rates_api', 'coingecko'),
(12, 'rates_api_crypto_currency', 'litecoin'),
(13, 'rates_api_currency', 'USD'),
(14, 'rates_api_interval', '5'),
(15, 'reinvest_status', 'disabled'),
(16, 'auto_suspend_users_interval', '0'),
(17, 'signup_bonus', '0'),
(18, 'referral_bonus', '0'),
(19, 'purchase_min', '1'),
(20, 'start_date', '2025-11-02 17:09:52'),
(21, 'blockchain_url', 'https://chain.so/tx/LTC/'),
(22, 'hashpower_price', '0.00000001'),
(23, 'daily_profit', '0.00000001'),
(24, 'hashpower_unit', 'GH'),
(25, 'period', '1'),
(26, 'calculator_periods', '1,3,5,7,8,30,90,365'),
(27, 'currency_name', 'Litecoin'),
(28, 'currency_code', 'LTC'),
(29, 'currency_decimals', '2'),
(30, 'balance_decimals', '15'),
(31, 'fiat_balance_decimals', '5'),
(32, 'withdrawal_method', 'manual'),
(33, 'withdrawal_deposit_required', 'yes'),
(34, 'withdrawal_min', '0.01000000'),
(35, 'withdrawal_max_auto', '0.50000000'),
(36, 'withdrawal_max_daily', '0'),
(37, 'deposit_gateway', 'hspay'),
(38, 'withdrawal_gateway', 'hspay'),
(39, 'deposit_currency_code', 'LTC'),
(40, 'withdrawal_currency_code', 'LTC'),
(41, 'withdrawal_fee_fixed', '0'),
(42, 'withdrawal_fee_percent', '0'),
(43, 'force_https', 'disabled'),
(44, 'multiple_accounts', 'no'),
(45, 'mining_counter_seconds', '86400'),
(46, 'mining_counter_speed', '1000'),
(47, 'coinpayments_pvk', 'PRIVATEKEY'),
(48, 'coinpayments_pbk', 'PUBLICKEY'),
(49, 'coinpayments_mode', 'gateway'),
(50, 'coinpayments_email', 'admin'),
(51, 'coinpayments_fee', '0'),
(52, 'coinpayments_mid', 'MERCHANT'),
(53, 'coinpayments_ipn', 'IPNSECRET'),
(54, 'paykassa_api_priority', 'slow'),
(55, 'cryptapi_network', 'crypto'),
(56, 'sendbit_api_hash', '$2y$12$SeCkgzINScl2DWSzs2ofYO2604UO6U.kI3mCWfoGYuCpvvbpzp9HG'),
(57, 'hspay_api_key', 'MRCEM-PGHQAH-BJ5PQP-5UQAO2-0W5ZKV'),
(58, 'hspay_base_url', 'https://hspay.io/api/v1'),
(59, 'hspay_merchant_name', 'user123'),
(60, 'hspay_user_source', 'email'),
(61, 'cookie_consent_message', 'This website uses cookies to ensure you get the best experience on our website.'),
(62, 'cookie_consent_popup_background', '#252E39'),
(63, 'cookie_consent_popup_text_color', '#FFFFFF'),
(64, 'cookie_consent_dismiss', 'Got it!'),
(65, 'cookie_consent_button_background', '#14A7D0'),
(66, 'cookie_consent_button_border_color', '#14A7D0'),
(67, 'cookie_consent_button_text_color', '#FFFFFF'),
(68, 'cookie_consent_link', 'Learn more'),
(69, 'cookie_consent_url', 'https://www.cookiesandyou.com/'),
(70, 'frontend_latest_transactions', '0'),
(71, 'frontend_latest_transactions_txid', '0');

-- --------------------------------------------------------

--
-- Table structure for table `tickets`
--

CREATE TABLE `tickets` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `priority_id` bigint(20) UNSIGNED NOT NULL,
  `status_id` bigint(20) UNSIGNED NOT NULL,
  `category_id` bigint(20) UNSIGNED NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT 0,
  `admin_read` tinyint(1) NOT NULL DEFAULT 0,
  `ticket_id` varchar(125) NOT NULL,
  `title` varchar(125) NOT NULL,
  `message` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_categories`
--

CREATE TABLE `ticket_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_comments`
--

CREATE TABLE `ticket_comments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `ticket_id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `admin_id` bigint(20) UNSIGNED DEFAULT NULL,
  `comment` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_priorities`
--

CREATE TABLE `ticket_priorities` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `css_class` varchar(125) DEFAULT NULL,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ticket_priorities`
--

INSERT INTO `ticket_priorities` (`id`, `name`, `css_class`, `default`, `created_at`, `updated_at`) VALUES
(1, 'Low', 'info', 1, '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(2, 'Medium', 'warning', 0, '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(3, 'High', 'danger', 0, '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `ticket_statuses`
--

CREATE TABLE `ticket_statuses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(125) NOT NULL,
  `css_class` varchar(125) DEFAULT NULL,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ticket_statuses`
--

INSERT INTO `ticket_statuses` (`id`, `name`, `css_class`, `default`, `created_at`, `updated_at`) VALUES
(1, 'Open', 'info', 1, '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(2, 'Waiting', 'warning', 0, '2025-11-02 11:09:52', '2025-11-02 11:09:52'),
(3, 'Closed', 'danger', 0, '2025-11-02 11:09:52', '2025-11-02 11:09:52');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` int(11) NOT NULL,
  `wallet` varchar(125) NOT NULL,
  `email` varchar(125) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(125) NOT NULL,
  `balance` decimal(30,15) NOT NULL DEFAULT 0.000000000000000,
  `status` enum('active','inactive','banned') NOT NULL DEFAULT 'active',
  `banned_message` text DEFAULT NULL,
  `allow_withdrawal` tinyint(1) NOT NULL DEFAULT 0,
  `ref_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ref_hits` int(11) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `comments` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `uuid`, `wallet`, `email`, `email_verified_at`, `password`, `balance`, `status`, `banned_message`, `allow_withdrawal`, `ref_id`, `ref_hits`, `ip`, `comments`, `remember_token`, `created_at`, `updated_at`) VALUES
(1, 456377502, 'LL5bDkSQdLCd45t2A9c8eibZkaEyHMrBqo', NULL, NULL, '$2y$10$XFZbJeKXHVMMhWoMlgrxh.OA7Zojrs7/z1ngRS3rpPeh158egOlBi', 0.000000000000000, 'active', NULL, 0, NULL, 0, '103.73.185.246', NULL, NULL, '2025-11-02 14:12:41', '2025-11-02 14:12:41'),
(2, 383331965, 'Tejejdbwodbdjwjcbskcnekxbdkwbcjdk', NULL, NULL, '$2y$10$7I8NOYqiFNiefbF4fcMEeeEhS1/4cXobUiErkdCz155hBI/qbfRfi', 0.000000000000000, 'active', NULL, 0, NULL, 0, '152.58.2.91', NULL, NULL, '2025-11-02 14:55:12', '2025-11-02 14:55:12'),
(3, 128495571, 'TM8JBvh7jhUAbcHwFozuq7UigvpJ7iyWm2', NULL, NULL, '$2y$10$lHHJ7EOBVD/fimWH6jJ9QOmj5odDiDaTWO54VxOUmVOOQIb.z54lS', 0.000000000000000, 'active', NULL, 0, NULL, 0, '110.226.180.100', NULL, NULL, '2025-11-02 15:28:09', '2025-11-02 15:28:09');

-- --------------------------------------------------------

--
-- Table structure for table `user_logs`
--

CREATE TABLE `user_logs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `type` enum('deposit','reinvest','withdrawal','bonus','penalty','affiliate','others') NOT NULL DEFAULT 'others',
  `description` text NOT NULL,
  `power` decimal(15,2) DEFAULT 0.00,
  `expire_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_mining_powers`
--

CREATE TABLE `user_mining_powers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `power` decimal(15,2) NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `status` enum('active','expired') NOT NULL DEFAULT 'active',
  `expire_date` datetime NOT NULL,
  `last_sum` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `withdrawals`
--

CREATE TABLE `withdrawals` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(30,15) NOT NULL,
  `fees` decimal(30,15) DEFAULT 0.000000000000000,
  `paid_amount` decimal(30,15) DEFAULT NULL,
  `tx_id` varchar(125) DEFAULT NULL,
  `status` enum('pending','processing','paid','canceled') NOT NULL DEFAULT 'pending',
  `cancel_reason` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `admins`
--
ALTER TABLE `admins`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `admins_email_unique` (`email`),
  ADD UNIQUE KEY `admins_username_unique` (`username`);

--
-- Indexes for table `deposits`
--
ALTER TABLE `deposits`
  ADD PRIMARY KEY (`id`),
  ADD KEY `deposits_user_id_foreign` (`user_id`);

--
-- Indexes for table `error_logs`
--
ALTER TABLE `error_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `error_logs_deposit_id_foreign` (`deposit_id`),
  ADD KEY `error_logs_withdrawal_id_foreign` (`withdrawal_id`),
  ADD KEY `error_logs_user_id_foreign` (`user_id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `faqs`
--
ALTER TABLE `faqs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `news`
--
ALTER TABLE `news`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `pages`
--
ALTER TABLE `pages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_resets`
--
ALTER TABLE `password_resets`
  ADD KEY `password_resets_email_index` (`email`);

--
-- Indexes for table `password_resets_admins`
--
ALTER TABLE `password_resets_admins`
  ADD KEY `password_resets_admins_email_index` (`email`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sessions_user_id_index` (`user_id`),
  ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `settings_key_index` (`key`);

--
-- Indexes for table `tickets`
--
ALTER TABLE `tickets`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `tickets_ticket_id_unique` (`ticket_id`),
  ADD KEY `tickets_user_id_foreign` (`user_id`),
  ADD KEY `tickets_admin_id_foreign` (`admin_id`),
  ADD KEY `tickets_priority_id_foreign` (`priority_id`),
  ADD KEY `tickets_status_id_foreign` (`status_id`),
  ADD KEY `tickets_category_id_foreign` (`category_id`);

--
-- Indexes for table `ticket_categories`
--
ALTER TABLE `ticket_categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ticket_comments`
--
ALTER TABLE `ticket_comments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ticket_comments_ticket_id_foreign` (`ticket_id`),
  ADD KEY `ticket_comments_user_id_foreign` (`user_id`),
  ADD KEY `ticket_comments_admin_id_foreign` (`admin_id`);

--
-- Indexes for table `ticket_priorities`
--
ALTER TABLE `ticket_priorities`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ticket_statuses`
--
ALTER TABLE `ticket_statuses`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_uuid_unique` (`uuid`),
  ADD UNIQUE KEY `users_wallet_unique` (`wallet`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_ref_id_foreign` (`ref_id`);

--
-- Indexes for table `user_logs`
--
ALTER TABLE `user_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_logs_user_id_foreign` (`user_id`);

--
-- Indexes for table `user_mining_powers`
--
ALTER TABLE `user_mining_powers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_mining_powers_user_id_foreign` (`user_id`);

--
-- Indexes for table `withdrawals`
--
ALTER TABLE `withdrawals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `withdrawals_user_id_foreign` (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `admins`
--
ALTER TABLE `admins`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `deposits`
--
ALTER TABLE `deposits`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `error_logs`
--
ALTER TABLE `error_logs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `faqs`
--
ALTER TABLE `faqs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `news`
--
ALTER TABLE `news`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `pages`
--
ALTER TABLE `pages`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=73;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=72;

--
-- AUTO_INCREMENT for table `tickets`
--
ALTER TABLE `tickets`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ticket_categories`
--
ALTER TABLE `ticket_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ticket_comments`
--
ALTER TABLE `ticket_comments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ticket_priorities`
--
ALTER TABLE `ticket_priorities`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `ticket_statuses`
--
ALTER TABLE `ticket_statuses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `user_logs`
--
ALTER TABLE `user_logs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_mining_powers`
--
ALTER TABLE `user_mining_powers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `withdrawals`
--
ALTER TABLE `withdrawals`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `deposits`
--
ALTER TABLE `deposits`
  ADD CONSTRAINT `deposits_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `error_logs`
--
ALTER TABLE `error_logs`
  ADD CONSTRAINT `error_logs_deposit_id_foreign` FOREIGN KEY (`deposit_id`) REFERENCES `deposits` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `error_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `error_logs_withdrawal_id_foreign` FOREIGN KEY (`withdrawal_id`) REFERENCES `withdrawals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tickets`
--
ALTER TABLE `tickets`
  ADD CONSTRAINT `tickets_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`),
  ADD CONSTRAINT `tickets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `ticket_categories` (`id`),
  ADD CONSTRAINT `tickets_priority_id_foreign` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priorities` (`id`),
  ADD CONSTRAINT `tickets_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `ticket_statuses` (`id`),
  ADD CONSTRAINT `tickets_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ticket_comments`
--
ALTER TABLE `ticket_comments`
  ADD CONSTRAINT `ticket_comments_admin_id_foreign` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`),
  ADD CONSTRAINT `ticket_comments_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ticket_comments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ref_id_foreign` FOREIGN KEY (`ref_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `user_logs`
--
ALTER TABLE `user_logs`
  ADD CONSTRAINT `user_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_mining_powers`
--
ALTER TABLE `user_mining_powers`
  ADD CONSTRAINT `user_mining_powers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `withdrawals`
--
ALTER TABLE `withdrawals`
  ADD CONSTRAINT `withdrawals_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
