<?php $__env->startSection('header_content'); ?>
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8"></div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-5">
        <div class="col-xl-12 mb-5 mb-xl-0">
            <?php echo $__env->make('themes.dashboard.default.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card shadow">
                <div class="card-header border-0">
                    <div class="row align-items-center">
                        <div class="col">
                            <h3 class="mb-0">Deposit History</h3>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped text-center">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">Invoice</th>
                                    <th scope="col">HashPower</th>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($deposit->invoice); ?></td>
                                        <td><?php echo e($deposit->power); ?> <?php echo e(setting('hashpower_unit')); ?>/s</td>
                                        <td><?php echo e(crypto_currency($deposit->amount)); ?></td>
                                        <td>
                                            <?php if($deposit->status === 'pending'): ?>
                                                <span class="badge badge-primary">Pending</span>
                                            <?php elseif($deposit->status === 'processing'): ?>
                                                <span class="badge badge-info">Processing</span>
                                            <?php elseif($deposit->status === 'paid'): ?>
                                                <span class="badge badge-success">Paid</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Canceled</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($deposit->created_at); ?></td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <?php if($deposit->status === 'pending'): ?>
                                                    <a href="<?php echo e(route('payment', $deposit->invoice)); ?>" class="btn btn-success"><i class="fa fa-money-bill"></i> Pay Now</a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(setting('blockchain_url').$deposit->tx_id); ?>" class="btn btn-info <?php if(!$deposit->tx_id): ?>disabled <?php endif; ?>" target="_blank"><i class="fa fa-eye"></i> View on Blockchain</a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td class="text-center" colspan="6">No deposits found!</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($deposits->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($deposits->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('themes.dashboard.default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/themes/dashboard/default//deposits.blade.php ENDPATH**/ ?>