<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?php if(count($errors) > 1): ?>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php else: ?>
            <?php echo e($errors->first()); ?>

        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if(setting('default_alerts') === 'alerts'): ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
<?php endif; ?>

<?php if(setting('default_alerts') === 'toastr'): ?>
    <?php $__env->startPush('additional_styles'); ?>
        <!-- Toastr -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin/plugins/toastr/toastr.min.css')); ?>">
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('additional_scripts'); ?>
        <!-- Toastr -->
        <script src="<?php echo e(asset('assets/admin/plugins/toastr/toastr.min.js')); ?>"></script>
        <?php if(session('success') || session('error')): ?>
        <script>
            //Toastr
            <?php if(session('success')): ?>
            toastr.success('<?php echo e(session('success')); ?>');
            <?php endif; ?>
            <?php if(session('error')): ?>
            toastr.error('<?php echo e(session('error')); ?>');
            <?php endif; ?>
        </script>
        <?php endif; ?>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php if(setting('default_alerts') === 'sweetalert'): ?>
    <?php $__env->startPush('additional_styles'); ?>
        <!-- SweetAlert2 -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/admin/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css')); ?>">
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('additional_scripts'); ?>
        <!-- SweetAlert2 -->
        <script src="<?php echo e(asset('assets/admin/plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
        <?php if(session('success') || session('error')): ?>
        <script>
            const sweetAlertTheme = display_cookie === 'dark' ? '#343a40' : '';
            //SweetAlert2
            const SweetAlert = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timerProgressBar: true,
                timer: 3000,
                background: sweetAlertTheme
            });
            <?php if(session('success')): ?>
            SweetAlert.fire({
                icon: 'success',
                text: '<?php echo e(session('success')); ?>'
            });
            <?php endif; ?>
            <?php if(session('error')): ?>
            SweetAlert.fire({
                'icon': 'error',
                'text': '<?php echo e(session('error')); ?>'
            });
            <?php endif; ?>
        </script>
        <?php endif; ?>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/admin/partials/alerts.blade.php ENDPATH**/ ?>