<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title><?php echo e(setting('site_name')); ?> - <?php echo e($page_title ?? 'Home'); ?></title>
    <meta name="description" content="<?php echo e(setting('meta_description')); ?>">
    <meta name="keywords" content="<?php echo e(setting('meta_keywords')); ?>">

    <!--Favicons-->
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('assets/favicons/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('assets/favicons/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('assets/favicons/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('assets/favicons/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('assets/favicons/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('assets/favicons/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('assets/favicons/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('assets/favicons/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/favicons/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('assets/favicons/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/favicons/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('assets/favicons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/favicons/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('assets/favicons/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('assets/favicons/ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">

    <!-- Icons -->
    <link href="<?php echo e(dashboard_assets('js/plugins/nucleo/css/nucleo.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(dashboard_assets('js/plugins/@fortawesome/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet">

    <!-- Argon CSS -->
    <link type="text/css" href="<?php echo e(dashboard_assets('css/argon-dashboard.css')); ?>" rel="stylesheet">

    <?php if(setting('cookie_consent_status') === 'yes'): ?>
    <!--Cookie Consent-->
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css" />
    <?php endif; ?>
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo $__env->yieldPushContent('head_styles'); ?>
    <?php echo setting('header_codes'); ?>

    <?php if(setting('custom_css_dashboard')): ?>
        <style>
            <?php echo setting('custom_css_dashboard'); ?>

        </style>
    <?php endif; ?>
</head>

<body>

<nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light bg-white" id="sidenav-main">
    <div class="container-fluid">
        <!-- Toggler -->
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#sidenav-collapse-main"
                aria-controls="sidenav-main" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <!-- Brand -->
        <a class="navbar-brand pt-0" href="<?php echo e(route('account')); ?>">
            <img src="<?php echo e(dashboard_assets('img/brand/blue.png')); ?>" class="navbar-brand-img" alt="...">
        </a>
        <!-- User -->
        <ul class="nav align-items-center d-md-none">
            <li class="nav-item dropdown">
                <a class="nav-link" href="#" role="button" data-toggle="dropdown" aria-haspopup="true"
                   aria-expanded="false">
                    <div class="media align-items-center">
              <span class="avatar avatar-sm rounded-circle">
                <img alt="Image placeholder" src="<?php echo e(dashboard_assets('img/theme/sketch.jpg')); ?>">
              </span>
                    </div>
                </a>
                <?php echo $__env->make('themes.dashboard.default.partials.user-dropdown-top-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </li>
        </ul>
        <!-- Collapse -->
        <div class="collapse navbar-collapse" id="sidenav-collapse-main">
            <!-- Collapse header -->
            <div class="navbar-collapse-header d-md-none">
                <div class="row">
                    <div class="col-6 collapse-brand">
                        <a href="#">
                            <img src="<?php echo e(dashboard_assets('img/brand/blue.png')); ?>">
                        </a>
                    </div>
                    <div class="col-6 collapse-close">
                        <button type="button" class="navbar-toggler" data-toggle="collapse"
                                data-target="#sidenav-collapse-main" aria-controls="sidenav-main" aria-expanded="false"
                                aria-label="Toggle sidenav">
                            <span></span>
                            <span></span>
                        </button>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('themes.dashboard.default.partials.sidebar-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</nav>
<div class="main-content">
    <!-- Navbar -->
    <nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
        <div class="container-fluid">
            <!-- Brand -->
            <a class="h4 mb-0 text-white text-uppercase d-none d-lg-inline-block"
               href="<?php echo e(route('index')); ?>">Home</a>
            <!-- User -->
            <ul class="navbar-nav align-items-center d-none d-md-flex">
                <li class="nav-item dropdown">
                    <a class="nav-link pr-0" href="<?php echo e(route('account')); ?>" role="button" data-toggle="dropdown" aria-haspopup="true"
                       aria-expanded="false">
                        <div class="media align-items-center">
                            <span class="avatar avatar-sm rounded-circle">
                              <img alt="Image placeholder" src="<?php echo e(dashboard_assets('img/theme/sketch.jpg')); ?>">
                            </span>
                            <div class="media-body ml-2 d-none d-lg-block">
                                <span class="mb-0 text-sm  font-weight-bold"><?php echo e(auth()->user()->wallet); ?></span>
                            </div>
                        </div>
                    </a>
                    <?php echo $__env->make('themes.dashboard.default.partials.user-dropdown-top-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </li>
            </ul>
        </div>
    </nav>
    <!-- End Navbar -->
    <?php echo $__env->yieldContent('header_content'); ?>

    <div class="container-fluid mt--7">

        <?php echo $__env->yieldContent('content'); ?>

        <!-- Footer -->
        <footer class="footer">
            <div class="row align-items-center justify-content-xl-between">
                <div class="col-xl-6">
                    <div class="copyright text-center text-xl-left text-muted">
                        &copy; <?php echo e(date('Y')); ?> <a href="<?php echo e(route('index')); ?>" class="font-weight-bold ml-1"><?php echo e(setting('site_name')); ?></a>. All rights reserved.
                    </div>
                </div>
                <div class="col-xl-6">
                    <ul class="nav nav-footer justify-content-center justify-content-xl-end">
                        <li class="nav-item">
                            <a href="javascript:void(0);" data-toggle="modal" data-target="#tosModal" class="nav-link">Terms of Service</a>
                        </li>
                        <li class="nav-item">
                            <a href="javascript:void(0);" data-toggle="modal" data-target="#privacyModal" class="nav-link">Privacy Policy</a>
                        </li>
                    </ul>
                </div>
                <div class="col-xl-12">
                    <?php echo $__env->make('themes.dashboard.default.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </footer>
    </div>
</div>

<?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('deposit')->html();
} elseif ($_instance->childHasBeenRendered('9UYq3UL')) {
    $componentId = $_instance->getRenderedChildComponentId('9UYq3UL');
    $componentTag = $_instance->getRenderedChildComponentTagName('9UYq3UL');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('9UYq3UL');
} else {
    $response = \Livewire\Livewire::mount('deposit');
    $html = $response->html();
    $_instance->logRenderedChild('9UYq3UL', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
<?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('withdrawal')->html();
} elseif ($_instance->childHasBeenRendered('tP8xMeI')) {
    $componentId = $_instance->getRenderedChildComponentId('tP8xMeI');
    $componentTag = $_instance->getRenderedChildComponentTagName('tP8xMeI');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('tP8xMeI');
} else {
    $response = \Livewire\Livewire::mount('withdrawal');
    $html = $response->html();
    $_instance->logRenderedChild('tP8xMeI', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>

<?php echo $__env->make('themes.dashboard.default.partials.tos-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('themes.dashboard.default.partials.privacy-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('themes.dashboard.default.partials.faqs-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Core -->
<script src="<?php echo e(dashboard_assets('js/plugins/jquery/dist/jquery.min.js')); ?>"></script>
<script src="<?php echo e(dashboard_assets('js/plugins/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>

<!-- Argon JS -->
<script src="<?php echo e(dashboard_assets('js/argon-dashboard.js')); ?>"></script>
<script src="<?php echo e(dashboard_assets('js/custom.js')); ?>"></script>

<?php if(setting('cookie_consent_status') === 'yes'): ?>
    <!--Cookie Consent-->
    <script src="https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js" data-cfasync="false"></script>
    <script>
        window.cookieconsent.initialise({
            "palette": {
                "popup": {
                    "background": "<?php echo e(setting('cookie_consent_popup_background')); ?>",
                    "text": "<?php echo e(setting('cookie_consent_popup_text_color')); ?>"
                },
                "button": {
                    <?php if(setting('cookie_consent_layout') === 'wire'): ?>
                    "background": "transparent",
                    "border": "<?php echo e(setting('cookie_consent_button_border_color')); ?>",
                    <?php else: ?>
                    "background": "<?php echo e(setting('cookie_consent_button_background')); ?>",
                    <?php endif; ?>
                    "text": "<?php echo e(setting('cookie_consent_button_text_color')); ?>"
                }
            },
            "position": "<?php echo e(setting('cookie_consent_position')); ?>",
            <?php if(setting('cookie_consent_position') === 'top-static'): ?>
            "static": true,
            <?php else: ?>
            "static": false,
            <?php endif; ?>
                    <?php if(setting('cookie_consent_layout') !== 'wire'): ?>
            "theme": "<?php echo e(setting('cookie_consent_layout')); ?>"
            <?php endif; ?>
        });
    </script>
<?php endif; ?>
<?php echo \Livewire\Livewire::scripts(); ?>

<?php echo $__env->yieldPushContent('footer_scripts'); ?>
<?php echo setting('footer_codes'); ?>

</body>

</html><?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/themes/dashboard/default/layout.blade.php ENDPATH**/ ?>