<?php $__env->startSection('header_content'); ?>
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">
                <?php echo $__env->make('themes.dashboard.default.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php if($unread_messages): ?>
                    <div class="alert alert-info">
                        <i class="fa fa-envelope"></i> You have <?php echo e($unread_messages); ?> <a href="<?php echo e(route('tickets.index')); ?>">unread messages</a>.
                    </div>
                <?php endif; ?>
                <!-- Card stats -->
                <div class="row mb-3">
                    <div class="col-xl-12 col-lg-6">
                        <div class="card card-stats mb-4 mb-xl-0 text-center">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col">
                                        <h5 class="card-title text-uppercase text-muted mb-0">Balance</h5>
                                        <span class="h2 font-weight-bold mb-0"><span id="miningBalance"><?php echo e(currency_format($user_balance, setting('balance_decimals'))); ?></span> <?php echo e(setting('currency_code')); ?></span>
                                    </div>
                                </div>
                                <?php if(setting('reinvest_status') === 'enabled'): ?>
                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#reinvestModal"><i class="fa fa-sync"></i> Reinvest</button>
                                    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('reinvest')->html();
} elseif ($_instance->childHasBeenRendered('nj9oaxL')) {
    $componentId = $_instance->getRenderedChildComponentId('nj9oaxL');
    $componentTag = $_instance->getRenderedChildComponentTagName('nj9oaxL');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('nj9oaxL');
} else {
    $response = \Livewire\Livewire::mount('reinvest');
    $html = $response->html();
    $_instance->logRenderedChild('nj9oaxL', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                <?php endif; ?>
                                <p class="mt-3 mb-0 text-muted text-sm">
                                    <span class="text-success mr-2"> <span id="dailyProfit"><?php echo e(currency_format($user_daily_profit, setting('balance_decimals'))); ?></span> <?php echo e(setting('currency_code')); ?></span>
                                    <span class="text-nowrap">Daily Profit</span>
                                </p>
                                <?php if(setting('auto_suspend_users_interval') >= 1 && !auth()->user()->allow_withdrawal): ?>
                                    <div class="alert alert-danger text-sm mt-3 mb-0"><i class="fa fa-exclamation-triangle"></i> You have not made any deposits yet and your account will be automatically disabled for inactivity at
                                        <strong><?php echo e(auth()->user()->created_at->addHours(setting('auto_suspend_users_interval'))->format('Y-m-d H:i:s')); ?></strong>. Make a deposit now and prevent your account from being deactivated.</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-4 col-lg-6">
                        <div class="card card-stats mb-4 mb-xl-0">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col">
                                        <h5 class="card-title text-uppercase text-muted mb-0">Current Value</h5>
                                        <span class="h2 font-weight-bold mb-0"><span id="fiatBalance"><?php echo e(currency_format($user_balance * $exchange_rate, setting('fiat_balance_decimals'))); ?></span> <?php echo e(setting('rates_api_currency')); ?></span>
                                    </div>
                                    <div class="col-auto">
                                        <div class="icon icon-shape bg-warning text-white rounded-circle shadow">
                                            <i class="fas fa-dollar-sign"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-3 mb-0 text-muted text-sm">
                                    <span class="text-nowrap">May vary based on market value</span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6">
                        <div class="card card-stats mb-4 mb-xl-0">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col">
                                        <h5 class="card-title text-uppercase text-muted mb-0">Total Referrals</h5>
                                        <span class="h2 font-weight-bold mb-0"><?php echo e($total_refs); ?></span>
                                    </div>
                                    <div class="col-auto">
                                        <div class="icon icon-shape bg-yellow text-white rounded-circle shadow">
                                            <i class="fas fa-users"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-3 mb-0 text-muted text-sm">
                                    <span class="text-nowrap"><a href="<?php echo e(route('referral-tools')); ?>">View details</a></span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6">
                        <div class="card card-stats mb-4 mb-xl-0">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col">
                                        <h5 class="card-title text-uppercase text-muted mb-0">Hashpower</h5>
                                        <span class="h2 font-weight-bold mb-0"><?php echo e(user_hashpower()); ?> <?php echo e(setting('hashpower_unit')); ?>/s</span>
                                    </div>
                                    <div class="col-auto">
                                        <div class="icon icon-shape bg-info text-white rounded-circle shadow">
                                            <i class="fas fa-server"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-3 mb-0 text-muted text-sm">
                                    <span class="text-nowrap">Total mining power</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-4">
        <div class="col-xl-6 mb-5 mb-xl-0">
            <div class="card shadow">
                <div class="card-header border-0">
                    <div class="row align-items-center">
                        <div class="col">
                            <h3 class="mb-0">Profit Details</h3>
                        </div>
                    </div>
                </div>
                <div class="card-body mb-lg-4">
                    <p>Calculation based on your current mining power</p>
                </div>
                <div class="table-responsive">
                    <table class="table align-items-center table-flush text-center">
                        <thead class="thead-light">
                        <tr>
                            <th scope="col">Amount</th>
                            <th scope="col">Period</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = calculator_periods(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $days): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <span><?php echo e(currency_format(user_hashpower() * setting('daily_profit') * $days, 8)); ?></span> <?php echo e(setting('currency_code')); ?>

                                </td>
                                <td>
                                    <?php
                                        $days_class = 'success';
                                        if($days >= 7 ): $days_class = 'info'; endif;
                                        if($days >= 30 ): $days_class = 'primary'; endif;
                                        if($days >= 365 ): $days_class = 'danger'; endif;
                                    ?>
                                    <span class="badge badge-<?php echo e($days_class); ?>">
                                        <?php if($days < 7): ?>
                                            <?php echo e($days); ?> <?php echo e($days === '1' ? 'day' : 'days'); ?>

                                        <?php elseif($days === '7'): ?>
                                            1 week
                                        <?php elseif($days === '14'): ?>
                                            2 weeks
                                        <?php elseif($days === '21'): ?>
                                            3 weeks
                                        <?php elseif($days === '30'): ?>
                                            1 month
                                        <?php elseif($days === '60'): ?>
                                            2 months
                                        <?php elseif($days === '90'): ?>
                                            3 months
                                        <?php elseif($days === '120'): ?>
                                            4 months
                                        <?php elseif($days === '150'): ?>
                                            5 months
                                        <?php elseif($days === '180'): ?>
                                            6 months
                                        <?php elseif($days === '210'): ?>
                                            7 months
                                        <?php elseif($days === '240'): ?>
                                            8 months
                                        <?php elseif($days === '270'): ?>
                                            9 months
                                        <?php elseif($days === '300'): ?>
                                            10 months
                                        <?php elseif($days === '330'): ?>
                                            11 months
                                        <?php elseif($days === '365'): ?>
                                            1 year
                                        <?php else: ?>
                                            <?php echo e($days); ?> days
                                        <?php endif; ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('profit-calculator')->html();
} elseif ($_instance->childHasBeenRendered('mXpa9l9')) {
    $componentId = $_instance->getRenderedChildComponentId('mXpa9l9');
    $componentTag = $_instance->getRenderedChildComponentTagName('mXpa9l9');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('mXpa9l9');
} else {
    $response = \Livewire\Livewire::mount('profit-calculator');
    $html = $response->html();
    $_instance->logRenderedChild('mXpa9l9', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer_scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function(e) {
            let currentRate = <?php echo e($exchange_rate); ?>;
            let balance = document.getElementById('miningBalance');
            const fiatBalance = document.getElementById('fiatBalance');
            const dailyProfit = document.getElementById('dailyProfit');
            let daily_profit = (dailyProfit.innerText);
            let balance_value = <?php echo e($user_balance); ?>;
            let per_second = (daily_profit / <?php echo e(setting('mining_counter_seconds', 86400)); ?>).toFixed(15);
            setInterval(function(){
                balance_value = parseFloat(balance_value)+parseFloat(per_second);
                balance.innerText = parseFloat(balance_value).toFixed(<?php echo e(setting('balance_decimals')); ?>);
                fiatBalance.innerText = (balance.innerText * currentRate).toFixed(<?php echo e(setting('fiat_balance_decimals')); ?>);
            }, <?php echo e(setting('mining_counter_speed', 1000)); ?>);
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('themes.dashboard.default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/themes/dashboard/default//index.blade.php ENDPATH**/ ?>