<?php $__env->startSection('header_content'); ?>
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8"></div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-5">
        <div class="col-xl-12 mb-5 mb-xl-0">
            <?php echo $__env->make('themes.dashboard.default.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card shadow">
                <div class="card-header border-0">
                    <div class="row align-items-center">
                        <div class="col">
                            <h3 class="mb-0">Withdrawals History</h3>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped text-center">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Fees</th>
                                    <th scope="col">Paid Amount</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">TX ID</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(crypto_currency($withdrawal->amount)); ?></td>
                                        <td><?php echo e(crypto_currency($withdrawal->fees)); ?></td>
                                        <td><?php echo e(crypto_currency($withdrawal->paid_amount)); ?></td>
                                        <td>
                                            <?php if($withdrawal->status === 'pending'): ?>
                                                <span class="badge badge-primary">Pending</span>
                                            <?php elseif($withdrawal->status === 'processing'): ?>
                                                <span class="badge badge-info">Processing</span>
                                            <?php elseif($withdrawal->status === 'paid'): ?>
                                                <span class="badge badge-success">Paid</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger" title="<?php echo e($withdrawal->cancel_reason); ?>">Canceled</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($withdrawal->created_at); ?></td>
                                        <td><a href="<?php echo e(setting('blockchain_url').$withdrawal->tx_id); ?>" class="btn btn-sm btn-info <?php if(!$withdrawal->tx_id): ?>disabled <?php endif; ?>" target="_blank" title="View on Blockchain"><i class="fa fa-eye"></i></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr><td class="text-center" colspan="6">No withdrawals found!</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($withdrawals->hasPages()): ?>
                <div class="card-footer">
                    <?php echo e($withdrawals->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('themes.dashboard.default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/themes/dashboard/default//withdrawals.blade.php ENDPATH**/ ?>