<!-- Main Sidebar Container -->
<aside class="main-sidebar <?php echo e(adminlte_classes('sidebar')); ?> elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('admin.index')); ?>" class="brand-link <?php echo e(adminlte_classes('brand')); ?>">
        <img src="<?php echo e(asset('assets/admin/dist/img/AdminLTELogo.png')); ?>" alt="Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light"><?php echo e(config('smartyscripts.script_name')); ?></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="<?php echo e(admin_avatar()); ?>" class="img-circle elevation-2" alt="User Image">
            </div>
            <div class="info">
                <a href="<?php echo e(route('admin.profile')); ?>" class="d-block"><?php echo e(auth()->user()->name); ?></a>
                <?php if(!empty(auth()->user()->getRoleNames())): ?>
                    <?php $__currentLoopData = auth()->user()->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <small class="text-muted"><?php echo e($role); ?></small>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column <?php echo e(adminlte_classes('sidebar_nav')); ?>" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
                     with font-awesome or any other icon font library -->
                <?php echo e(adminlte_sidebar_menu()); ?>

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /home/demominescript/public_html/CyberMiner/cyberminer/resources/views/admin/partials/sidebar.blade.php ENDPATH**/ ?>