<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix(config('cyber_miner.backend_prefix'))->group(function () {
    //Logout
    Route::post('logout', [\App\Http\Controllers\Administration\Auth\LoginController::class, 'logout'])->name('admin.logout');
    //Login
    Route::get('login', [\App\Http\Controllers\Administration\Auth\LoginController::class, 'showLoginForm'])->name('admin.login');
    Route::post('login', [\App\Http\Controllers\Administration\Auth\LoginController::class, 'login'])->name('admin.login');
    //2FA
    Route::get('2fa', [\App\Http\Controllers\Administration\Auth\TwoFactorController::class, 'index'])->name('admin.2fa');
    Route::post('2fa', [\App\Http\Controllers\Administration\Auth\TwoFactorController::class, 'send'])->name('admin.2fa');
    Route::get('2fa/resend', [\App\Http\Controllers\Administration\Auth\TwoFactorController::class, 'resend'])->name('admin.2fa.resend');
    //Confirm password
    Route::get('confirm', [\App\Http\Controllers\Administration\Auth\ConfirmPasswordController::class, 'showConfirmForm'])->name('admin.password.confirm');
    Route::post('confirm', [\App\Http\Controllers\Administration\Auth\ConfirmPasswordController::class, 'confirm'])->name('admin.password.confirm');
    //Email verification
    Route::get('email/verify', [\App\Http\Controllers\Administration\Auth\VerificationController::class, 'show'])->name('admin.verification.notice');
    Route::get('email/verify/{id}/{hash}', [\App\Http\Controllers\Administration\Auth\VerificationController::class, 'verify'])->name('admin.verification.verify');
    Route::post('email/resend', [\App\Http\Controllers\Administration\Auth\VerificationController::class, 'resend'])->name('admin.verification.resend');
    //Forgot Password
    Route::get('password/reset', [\App\Http\Controllers\Administration\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])->name('admin.password.request');
    Route::post('password/email', [\App\Http\Controllers\Administration\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])->name('admin.password.email');
    //Reset Password
    Route::get('password/reset/{token}', [\App\Http\Controllers\Administration\Auth\ResetPasswordController::class, 'showResetForm'])->name('admin.password.reset');
    Route::post('password/reset', [\App\Http\Controllers\Administration\Auth\ResetPasswordController::class, 'reset'])->name('admin.password.update');

    Route::group(['middleware' => ['auth:admin', 'admin.verified', '2fa.admin']], function () {
        //Dashboard
        Route::get('/', [\App\Http\Controllers\Administration\HomeController::class, 'index'])->name('admin.index');
        Route::get('check_updates', [\App\Http\Controllers\Administration\HomeController::class, 'updateCheck'])->middleware('throttle:3,1')->name('admin.check_updates');
        //Profile
        Route::get('profile', [\App\Http\Controllers\Administration\AdminProfileController::class, 'index'])->middleware('admin.password.confirm')->name('admin.profile');
        Route::post('profile', [\App\Http\Controllers\Administration\AdminProfileController::class, 'update'])->name('admin.profile');
        //Pages
        Route::as('admin')->resource('pages', \App\Http\Controllers\Administration\ManagePageController::class)->except('show');
        //News
        Route::as('admin')->resource('news', \App\Http\Controllers\Administration\ManageNewsController::class)->except('show');
        //FAQ
        Route::as('admin')->resource('faqs', \App\Http\Controllers\Administration\ManageFaqController::class)->except('show');
        //Admins
        Route::get('admins/impersonate/enter/{admin}', [\App\Http\Controllers\Administration\ManageAdminController::class, 'impersonate'])->name('admin.admins.impersonate');
        Route::get('admins/impersonate/leave', [\App\Http\Controllers\Administration\ManageAdminController::class, 'impersonateStop'])->name('admin.admins.impersonate.stop');
        Route::as('admin')->resource('admins', \App\Http\Controllers\Administration\ManageAdminController::class)->except('show');
        //Users
        Route::get('users/impersonate/enter/{user}', [\App\Http\Controllers\Administration\ManageUserController::class, 'impersonate'])->name('admin.users.impersonate');
        Route::get('users/impersonate/leave', [\App\Http\Controllers\Administration\ManageUserController::class, 'impersonateStop'])->name('admin.users.impersonate.stop');
        Route::get('users/datatables/deposits/{user}', [\App\Http\Controllers\Administration\ManageUserController::class, 'datatablesDeposits'])->name('admin.users.datatables.deposits');
        Route::get('users/datatables/withdrawals/{user}', [\App\Http\Controllers\Administration\ManageUserController::class, 'datatablesWithdrawals'])->name('admin.users.datatables.withdrawals');
        Route::get('users/datatables/history/{user}', [\App\Http\Controllers\Administration\ManageUserController::class, 'datatablesHistory'])->name('admin.users.datatables.history');
        Route::get('users/datatables/plans/{user}', [\App\Http\Controllers\Administration\ManageUserController::class, 'datatablesMiningPlans'])->name('admin.users.datatables.plans');
        Route::post('users/{user}/bonus', [\App\Http\Controllers\Administration\ManageUserController::class, 'bonusAndPenalty'])->name('admin.users.bonus');
        Route::as('admin')->resource('users', \App\Http\Controllers\Administration\ManageUserController::class)->except('show');
        //Deposits
        Route::as('admin')->resource('deposits', \App\Http\Controllers\Administration\ManageDepositController::class)->except('show', 'create', 'store');
        //Withdrawals
        Route::get('withdrawals_requests', [\App\Http\Controllers\Administration\ManageWithdrawalController::class, 'pending'])->name('admin.withdrawals.pending');
        Route::as('admin')->resource('withdrawals', \App\Http\Controllers\Administration\ManageWithdrawalController::class)->except('show', 'create', 'store');
        //Roles
        Route::as('admin')->resource('roles', \App\Http\Controllers\Administration\ManageRoleController::class)->except('show');
        Route::as('admin')->resource('permissions', \App\Http\Controllers\Administration\ManagePermissionController::class)->except('show');
        //Settings
        Route::get('settings', [\App\Http\Controllers\Administration\ManageSettingController::class, 'index'])->name('admin.settings');
        Route::post('settings', [\App\Http\Controllers\Administration\ManageSettingController::class, 'update'])->name('admin.settings');
        Route::get('settings/clear-cache', [\App\Http\Controllers\Administration\ManageSettingController::class, 'flushCache'])->name('admin.settings.clear_cache');
        Route::get('update-script', [\App\Http\Controllers\Administration\ManageSettingController::class, 'showUpdateForm'])->name('admin.update_script');
        Route::post('update-script', [\App\Http\Controllers\Administration\ManageSettingController::class, 'updateScript']);
        //Error Logs
        Route::as('admin')->resource('error_logs', \App\Http\Controllers\Administration\ManageErrorLogController::class)->only('index', 'show', 'destroy');
        //Faqs
        Route::as('admin')->resource('faqs', \App\Http\Controllers\Administration\ManageFaqController::class)->except('show');
        //Contacts
        Route::as('admin')->resource('contacts', \App\Http\Controllers\Administration\ManageContactController::class)->except('show', 'create', 'store');
        //Deposits
        Route::as('admin')->resource('deposits', \App\Http\Controllers\Administration\ManageDepositController::class)->except('show', 'create', 'store');
        //Withdrawals
        Route::as('admin')->resource('withdrawals', \App\Http\Controllers\Administration\ManageWithdrawalController::class)->except('show', 'create', 'store');
        //Withdrawal Requests
        Route::put('withdrawal_requests/pay/{withdrawal}', [\App\Http\Controllers\Administration\ManageWithdrawalController::class, 'pay'])->name('admin.withdrawal_requests.pay');
        //Tickets
        Route::as('admin')->resource('tickets', \App\Http\Controllers\Administration\ManageTicketController::class)->except('show', 'create', 'store');
        Route::post('tickets/{ticket}/comment', [\App\Http\Controllers\Administration\ManageTicketController::class, 'comment'])->name('admin.tickets.comment');
        //Ticket Status
        Route::as('admin')->resource('ticket_status', \App\Http\Controllers\Administration\ManageTicketStatusController::class)->except('show');
        //Ticket Priorities
        Route::as('admin')->resource('ticket_priorities', \App\Http\Controllers\Administration\ManageTicketPriorityController::class)->except('show');
        //Ticket Categories
        Route::as('admin')->resource('ticket_categories', \App\Http\Controllers\Administration\ManageTicketCategoryController::class)->except('show');
        //Error Logs
        Route::as('admin')->resource('error_logs', \App\Http\Controllers\Administration\ManageErrorLogController::class)->only('index', 'show', 'destroy');
    });
});
