<div class="row">
    <div class="col-lg-12 col-sm-12 text-center">
        <p>Redirecting to HSPay, please wait... <i class="fa fa-spinner fa-spin"></i></p>
        @php($params = isset($invoice_params) ? (object)$invoice_params : null)
        @php($payUrl = $params->data->pay_url ?? null)
        @if($payUrl)
            <a href="{{ $payUrl }}" id="hspayLink" class="btn btn-primary" rel="noreferrer noopener">Continue to HSPay</a>
        @else
            <form action="https://hspay.io/merchant/checkout" method="post" id="payment">
                <input type="hidden" name="merchant_id" value="{{ setting('hspay_merchant_id') }}">
                <input type="hidden" name="amount" value="{{ $invoice->amount }}">
                <input type="hidden" name="currency" value="{{ setting('deposit_currency_code') }}">
                <input type="hidden" name="invoice" value="{{ $invoice->invoice }}">
                <input type="hidden" name="callback_url" value="{{ route('ipn.hspay') }}">
                <input type="hidden" name="success_url" value="{{ route('ipn.success') }}">
                <input type="hidden" name="cancel_url" value="{{ route('ipn.fail') }}">
            </form>
        @endif
    </div>
</div>

@push('footer_scripts')
<script>
    document.addEventListener('DOMContentLoaded', function(){
        var link = document.getElementById('hspayLink');
        if (link) { link.click(); return; }
        var form = document.getElementById('payment');
        if (form) { form.submit(); }
    });
</script>
@endpush
