@extends('install.layout')

@section('content')
    <div class="row">
        <div class="col-12 mb-4 mb-lg-0">
            <div class="card">
                <div class="card-body">
                    <h1 class="h2">{{ $page_title }}</h1>
                    <p>Congratulations, the installation process was completed successfully!</p>
                    <p>An admin account was created automatically, and you can use the details below to access the Admin Panel.</p>
                    <h5>Admin Access Details</h5>
                    <ul class="list-unstyled">
                        <li><strong>URL</strong>: <a href="{{ route('admin.index') }}" target="_blank">{{ route('admin.index') }}</a></li>
                        <li><strong>Username</strong>: admin</li>
                        <li><strong>Username</strong>: 123456</li>
                    </ul>
                    <p>We at Smarty Scripts wish you success on your new website that is starting now, and that our script meets your expectations and needs in the best possible way.</p>
                    <p>And don't forget, if you find any kind of error, want to suggest new features or if you have any questions about how a specific feature of this script works, don't hesitate to get in touch with us, we'll be happy to assist you.</p>
                    <div class="alert alert-danger">Click on the "<strong>Finish Installation Process</strong>" button to complete the installation process.</div>
                </div>
                <div class="card-footer">
                    <button type="button" href="#sendForm" class="btn btn-success" onclick="event.preventDefault();document.getElementById('formStep6').submit();">Finish Installation Process</button>
                    <form action="{{ route('install.step6') }}" method="post" id="formStep6">
                        @csrf
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        Livewire.on('updatedTerminal', status => {
            let terminal = document.getElementById('terminal');
            console.log(terminal)
            console.log(status)
            terminal.append(status);
        })
    </script>
@endpush