@extends('install.layout')

@section('content')
    <div class="row">
        <div class="col-12 mb-4 mb-lg-0">
            <div class="card">
                <div class="card-body">
                    <h1 class="h2">{{ $page_title }}</h1>
                    <p>Put <strong>DoniaWeB</strong> in the License box, then click <strong>Validate License</strong> and continue with the installation process.</p>
                    <div class="row mb-2">
                        <div class="col-4">
                            <label for="domain">Your Domain: </label>
                            <div class="input-group">
                                <input type="url" id="url" class="form-control" readonly value="{{ secure_url('') }}">
                                <div class="input-group-text" title="Copy to Clipboard" onclick="copy_url();"><i class="fa fa-copy"></i></div>
                            </div>
                            <small class="form-text text-success" style="display: none" id="url_copied">Copied to Clipboard</small>
                        </div>
                    </div>
                    <h4>Generating a New License</h4>
                    
                    @livewire('install.check-license')
                </div>
                <div class="card-footer">
                    <a href="{{ route('install.step2') }}" class="btn btn-danger"><i class="fa fa-caret-left"></i> Back</a>
                    <a href="{{ route('install.step4') }}" class="btn btn-info @if(!config('smartyscripts.license_key'))disabled @endif">Continue <i class="fa fa-caret-right"></i></a>
                </div>
            </div>
        </div>
    </div>
@endsection