@extends('install.layout')

@section('content')
    <div class="row">
        <div class="col-12 mb-4 mb-lg-0">
            <div class="card">
                <div class="card-body">
                    <h1 class="h2">{{ $page_title }}</h1>
                    <p>The following folders need read/write permissions for the correct operation of the script.</p>
                    <p>You can change folder permissions through cPanel's "File Manager" by clicking on the folder name and using the "Change Permissions" menu.</p>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">Folder</th>
                                <th scope="col">Required</th>
                                <th scope="col">Using</th>
                                <th scope="col">Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($folders as $fol => $pem)
                                @php $permission = substr(sprintf('%o', fileperms(base_path($fol))), -3) @endphp
                                <tr>
                                    <td>{{base_path($fol)}}</td>
                                    <td>{{$pem}}</td>
                                    <td>{{$permission}}</td>
                                    <td>
                                        @if($permission >= $pem)
                                            <span class="badge bg-success rounded-pill">Ok</span>
                                        @else
                                            @php $hasErrors = TRUE; @endphp
                                            <span class="badge bg-danger rounded-pill">{{$permission}}</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <a href="{{ route('install.step1') }}" class="btn btn-danger"><i class="fa fa-caret-left"></i> Back</a>
                    @if($hasErrors === TRUE)
                        <a href="{{ url()->current() }}" class="btn btn-warning"><i class="fa fa-sync"></i> Recheck</a>
                    @else
                        <a href="{{ route('install.step3') }}" class="btn btn-info">Continue <i
                                    class="fa fa-caret-right"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection