@extends('install.layout')

@section('content')
    <div class="row">
        <div class="col-12 mb-4 mb-lg-0">
            <div class="card">
                <div class="card-body">
                    <h1 class="h2">{{ $page_title }}</h1>
                    <p>Make sure your hosting plan has the minimum requirements necessary for the script to work. All
                        items must have "Ok" status, if any of them have the "Error" message you need to correct before
                        proceeding with the installation.</p>
                    <p>If you use cPanel, you can access the "<b>Select PHP Version</b>" menu to change the PHP version
                        or enable the required extensions. If any of the extensions can not be enabled, please contact
                        your hosting technical support for assistance.</p>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center"><b>PHP
                                Version:</b> {{ $php['version'] }}
                            <span class="badge @if($supported)bg-success @else bg-danger @endif rounded-pill">{{ PHP_VERSION }}</span>
                        </li>
                        @if(!$supported) @php $hasErrors = TRUE; @endphp @endif
                        <li class="list-group-item d-flex justify-content-between align-items-center"><b>PHP
                                Extensions:</b></li>
                        <li class="list-group-item">
                            <ul class="list-group">
                                @foreach($php['extensions'] as $ext)
                                    <li class="list-group-item d-flex justify-content-between align-items-center">{{$ext}}
                                        @if(extension_loaded($ext))
                                            <span class="badge bg-success rounded-pill">Ok</span>
                                        @else
                                            @php $hasErrors = TRUE; @endphp
                                            <span class="badge bg-danger rounded-pill">Error</span>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center"><b>Apache
                                Extensions:</b></li>
                        <li class="list-group-item">
                            @if(!function_exists('apache_get_modules'))
                                <p class="text-danger">Your host configuration does not allow verification of Apache
                                    extensions, you can continue with script installation, but it is recommended that
                                    you verify that your host has the following requirements to ensure proper script
                                    operation.</p>
                            @endif
                            <ul class="list-group">
                                @foreach($apache['extensions'] as $aext)
                                    <li class="list-group-item d-flex justify-content-between align-items-center">{{$aext}}
                                        @if(!function_exists('apache_get_modules'))
                                            <span class="badge bg-warning rounded-pill">Unknown</span>
                                        @elseif(in_array($aext,apache_get_modules()))
                                            <span class="badge bg-success rounded-pill">Ok</span>
                                        @else
                                            @php $hasErrors = TRUE; @endphp
                                            <span class="badge bg-danger rounded-pill">Error</span>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="card-footer">
                    <a href="{{ route('install.index') }}" class="btn btn-danger"><i class="fa fa-caret-left"></i> Back</a>
                    @if($hasErrors === TRUE)
                        <a href="{{ url()->current() }}" class="btn btn-warning"><i class="fa fa-sync"></i> Recheck</a>
                    @else
                        <a href="{{ route('install.step2') }}" class="btn btn-info">Continue <i
                                    class="fa fa-caret-right"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection