<div>
    <div class="card-body">
        <h1 class="h2">{{ $page_title }}</h1>
        <p>Let's configure the basic script data to proceed with the installation.</p>
        <form>
            @csrf
            <h5>Basic Settings</h5>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Site Name</label>
                        <input type="text" name="app_name"
                               class="form-control @error('app_name') is-invalid @enderror"
                               placeholder="Your Site Name" wire:model="app_name">
                        <small class="form-text">Name of your site</small>
                        @error ('app_name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>App URL</label>
                        <input type="url" name="app_url"
                               class="form-control @error('app_url') is-invalid @enderror"
                               placeholder="Your Site URL"
                               wire:model.defer="app_url"
                               value="{{ old('app_url', request()->getSchemeAndHttpHost()) }}">
                        <small class="form-text">Eg.: http://www.yoursite.com. Without / at end</small>
                        @error ('app_url')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Admin URL Prefix <small>({{ $app_url . '/' . $admin_prefix }})</small></label>
                        <input type="text" name="admin_prefix"
                               class="form-control @error('admin_prefix') is-invalid @enderror"
                               placeholder="Eg: admin, control, my_panel"
                               wire:model="admin_prefix"
                               value="{{ old('admin_prefix') }}">
                        <small class="form-text">Admin URL Prefix. Alpha numeric characters, dashes or
                            underscores</small>
                        @error ('admin_prefix')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
            </div>
            <hr>
            <h5>Database Settings</h5>
            <p>
                <a class="btn btn-sm btn-success" data-toggle="collapse" href="#databaseTutorial" role="button"
                   aria-expanded="false" aria-controls="databaseTutorial"><i class="far fa-file-alt"></i>
                    Short Tutorial</a>
                <a class="btn btn-sm btn-danger"
                   href="https://www.youtube.com/results?search_query=cpanel+create+database&page=&utm_source=opensearch"
                   target="_blank"><i class="fab fa-youtube"></i> Video Tutorials on Youtube</a>
                <a class="btn btn-sm btn-info" href="https://vimeo.com/search?q=cpanel%20create%20database"
                   target="_blank"><i class="fab fa-vimeo"></i> Video Tutorials on Vimeo</a>
            </p>
            <div class="collapse" id="databaseTutorial">
                <div class="card card-body">
                    <small>
                        <ol>
                            <li>Access the cPanel of your hosting</li>
                            <li>Click on "MySQL® Databases"</li>
                            <li>On "Create New Database", fill the field with a name for your database and
                                click on "Create Database" button. Copy and paste the database name on
                                "Database Name" field below
                            </li>
                            <li>On "Add New User", fill the field with a username for your database. Click
                                on "Password Generator" button, copy the generated password and paste on
                                "Database Password" field below. Check "I have copied this password in a
                                safe place" field and click on "Use Password" button. Click on "Create User"
                                button, copy and paste the username on "Database Username" field below.
                            </li>
                            <li>On "Add User To Database", choose the username and database created before,
                                click on "Add" button, check "ALL PRIVILEGES" box and click on "Make
                                Changes" button.
                            </li>
                        </ol>
                    </small>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Driver</label>
                        <select name="db_driver"
                                wire:model.defer="db_driver"
                                class="form-select @error('db_driver') is-invalid @enderror">
                            <option value="mysql">MySql - Default</option>
                            <option value="sqlite">SqLite</option>
                            <option value="pgsql">PgSql</option>
                            <option value="sqlsrv">SqlSrv</option>
                        </select>
                        @error ('db_driver')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Host</label>
                        <input type="text" name="db_host"
                               wire:model.defer="db_host"
                               class="form-control @error('db_host') is-invalid @enderror"
                               placeholder="Your Database Host">
                        <small class="form-text">Eg.: localhost, 127.0.0.1 or YourHostingDBUrl</small>
                        @error ('db_host')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Port</label>
                        <input type="number" name="db_port"
                               wire:model.defer="db_port"
                               class="form-control @error('db_port') is-invalid @enderror"
                               placeholder="Your Database Port">
                        <small class="form-text">Default 3306</small>
                        @error ('db_port')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Name</label>
                        <input type="text" name="db_name"
                               wire:model.defer="db_name"
                               class="form-control @error('db_name') is-invalid @enderror"
                               placeholder="Your Database Name">
                        @error ('db_name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Username</label>
                        <input type="text" name="db_user"
                               wire:model.defer="db_user"
                               class="form-control @error('db_user') is-invalid @enderror"
                               placeholder="Your Database Username">
                        @error ('db_user')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Database Password</label>
                        <input type="text" name="db_pass"
                               wire:model.defer="db_pass"
                               class="form-control @error('db_pass') is-invalid @enderror"
                               placeholder="Your Database Password">
                        @error ('db_pass')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="mt-3">
                    <button class="btn btn-sm btn-primary" type="button" wire:click="testConnection" wire:loading.class="disabled"><i class="fa fa-plug"></i>
                        Test Connection</button>
                    @if (session('connected'))
                        <small class="text text-success ml-2" wire:loading.remove>Connection successfully!</small>
                    @elseif (session('connection_error'))
                        <small class="text text-danger ml-2" wire:loading.remove>{{ session('connection_error') }}</small>
                    @endif
                </div>
            </div>
            <hr>
            <h5>Mail Settings (Outgoing Server)</h5>
            <p>
                <a class="btn btn-sm btn-success" data-toggle="collapse" href="#emailTutorial" role="button"
                   aria-expanded="false" aria-controls="emailTutorial"><i class="far fa-file-alt"></i> Short
                    Tutorial</a>
                <a class="btn btn-sm btn-danger"
                   href="https://www.youtube.com/results?search_query=cpanel+create+email&page=&utm_source=opensearch"
                   target="_blank"><i class="fab fa-youtube"></i> Video Tutorials on Youtube</a>
                <a class="btn btn-sm btn-info" href="https://vimeo.com/search?q=cpanel%20create%20email"
                   target="_blank"><i class="fab fa-vimeo"></i> Video Tutorials on Vimeo</a>
            </p>
            <div class="collapse" id="emailTutorial">
                <div class="card card-body">
                    <small>
                        <ol>
                            <li>Access the cPanel of your hosting</li>
                            <li>Click on "Email Accounts"</li>
                            <li>Click on "Create" button</li>
                            <li>On "Domain", choose your domain(if you have more than one)</li>
                            <li>On "Username" field, choose a username to use. This username will be your
                                email address. Eg.: youUsername@yourDomain.com. Copy and paste this email
                                address on "Mail Username" field below
                            </li>
                            <li>On "Password" field, choose a password for this mail account. Fill "Mail
                                Password" field below with this same password
                            </li>
                            <li>Click on "Create" button to create this mail address</li>
                            <li>In the list of email accounts, locate the created email, click on "Connect
                                Devices"
                            </li>
                            <li>On "Mail Client Manual Settings", copy the "Outgoing Server" url and paste
                                on "Mail Host" field below
                            </li>
                            <li>Copy and paste "SMTP Port" number on "Mail Port" field below</li>
                        </ol>
                    </small>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Driver</label>
                        <select name="mail_driver"
                                wire:model.defer="mail_driver"
                                class="form-select @error('mail_driver') is-invalid @enderror">
                            <option value="smtp">SMTP - Default</option>
                            <option value="sendmail">Sendmail</option>
                            <option value="mailgun">Mailgun</option>
                            <option value="mandrill">Mandrill</option>
                            <option value="ses">Ses</option>
                            <option value="sparkpost">Sparkpost</option>
                            <option value="log">Log</option>
                            <option value="array">Array</option>
                        </select>
                        @error ('mail_driver')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Host</label>
                        <input type="text" name="mail_host"
                               wire:model.defer="mail_host"
                               class="form-control @error('mail_host') is-invalid @enderror"
                               placeholder="Your Mail Host">
                        <small class="form-text">Eg.: mail.yourdomain.com | smtp.yourdomain.com</small>
                        @error ('mail_host')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Port</label>
                        <input type="number" name="mail_port" min="1"
                               wire:model.defer="mail_port"
                               class="form-control @error('mail_port') is-invalid @enderror"
                               placeholder="Your Mail Port">
                        <small class="form-text">Eg.: 465, 587</small>
                        @error ('mail_port')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Username</label>
                        <input type="text" name="mail_user"
                               wire:model.defer="mail_user"
                               class="form-control @error('mail_user') is-invalid @enderror"
                               placeholder="Your Mail Username">
                        <small class="form-text">Eg.: username@yourdomain.com</small>
                        @error ('mail_user')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Password</label>
                        <input type="text" name="mail_pass"
                               wire:model.defer="mail_pass"
                               class="form-control @error('mail_pass') is-invalid @enderror"
                               placeholder="Your Mail Password">
                        @error ('mail_pass')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Mail Encryption</label>
                        <select name="mail_encryption"
                                wire:model.defer="mail_encryption"
                                class="form-select @error('mail_encryption') is-invalid @enderror">
                            <option value="ssl" selected>SSL - Default</option>
                            <option value="tls">TLS</option>
                            <option value="null">Null</option>
                        </select>
                        @error ('mail_encryption')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Send Mail From Address</label>
                        <input type="text" name="mail_sender"
                               wire:model.defer="mail_sender"
                               class="form-control @error('mail_sender') is-invalid @enderror"
                               placeholder="Email sender address">
                        <small class="form-text">Eg.: username@yourdomain.com</small>
                        @error ('mail_sender')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="mt-3">
                    <div class="form-group col-4">
                        <label for="mail_recipient">Email Address</label>
                        <div class="input-group">
                            <input type="email" id="mail_recipient" wire:model.defer="mail_recipient" class="form-control @error('mail_recipient') is-invalid @enderror" placeholder="Enter your email to test SMTP">
                            <button class="btn btn-sm btn-primary" type="button" wire:click="testMail" wire:loading.class="disabled"><i class="fa fa-at"></i>
                                Send Test Mail</button>
                            @error ('mail_recipient')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                    </div>
                    @if (session('mail_sent'))
                        <small class="text text-success ml-2" wire:loading.remove>Mail sent successfully!</small>
                    @elseif (session('mail_error'))
                        <small class="text text-danger ml-2" wire:loading.remove>{{ session('mail_error') }}</small>
                    @endif
                </div>
            </div>
            <hr>
            <h5>Development Settings</h5>
            <p class="alert alert-danger">If you are not a developer, don't change this fields.</p>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Script Environment</label>
                        <select name="app_environment"
                                wire:model.defer="app_environment"
                                class="form-select @error('app_environment') is-invalid @enderror">
                            <option value="production">Production - Default</option>
                            <option value="local">Local</option>
                            <option value="development">Development</option>
                            <option value="qa">Qa</option>
                            <option value="other">Other</option>
                        </select>
                        @error ('app_environment')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>App Debug</label>
                        <select name="app_debug"
                                wire:model.defer="app_debug"
                                class="form-select @error('app_debug') is-invalid @enderror">
                            <option value="false" selected>No - Default</option>
                            <option value="true">Yes</option>
                        </select>
                        @error ('app_debug')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Debugbar</label>
                        <select name="app_debugbar"
                                wire:model.defer="app_debugbar"
                                class="form-select @error('app_debugbar') is-invalid @enderror">
                            <option value="false" selected>No - Default</option>
                            <option value="true">Yes</option>
                        </select>
                        @error ('app_debugbar')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Log Level</label>
                        <select name="app_log"
                                wire:model.defer="app_log"
                                class="form-select @error('app_log') is-invalid @enderror">
                            <option value="debug" selected>Debug - Default</option>
                            <option value="info">Info</option>
                            <option value="notice">Notice</option>
                            <option value="warning">Warning</option>
                            <option value="error">Error</option>
                            <option value="critical">Critical</option>
                            <option value="alert">Alert</option>
                            <option value="emergency">Emergency</option>
                        </select>
                        @error ('app_log')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="card-footer">
        <a href="{{ route('install.step3') }}" class="btn btn-danger"><i class="fa fa-caret-left"></i> Back</a>
        @if(session('current_step') <= 4)
            <button type="button" class="btn btn-success" wire:click="install" wire:loading.remove>Continue</button>
            <button type="button" class="btn btn-success" wire:loading><i class="fa fa-spinner fa-spin"></i> Please Wait...</button>
        @else
            <a href="{{ route('install.step5') }}" class="btn btn-info @if(!config('smartyscripts.license_key'))disabled @endif">Continue
                <i class="fa fa-caret-right"></i></a>
        @endif
    </div>
</div>
