<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ config('smartyscripts.script_name') }} Install Wizard - {{ $page_title ?? 'Welcome' }}</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.0.0-alpha1/css/bootstrap.min.css"
          integrity="sha384-r4NyP46KrjDleawBgD5tp8Y7UzmLA05oM1iAEQ17CSuDqnUK2+k9luXQOfXJCJ4I" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
          integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <style>
        .sidebar {
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            z-index: 100;
            padding: 90px 0 0;
            box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
            z-index: 99;
        }

        @media (max-width: 767.98px) {
            .sidebar {
                top: 11.5rem;
                padding: 0;
            }
        }

        .navbar {
            box-shadow: inset 0 -1px 0 rgba(0, 0, 0, .1);
        }

        @media (min-width: 767.98px) {
            .navbar {
                top: 0;
                position: sticky;
                z-index: 999;
            }
        }

        .sidebar .nav-link {
            color: #333;
        }

        .sidebar .nav-link.active {
            color: #0d6efd;
        }
    </style>
    @livewireStyles
</head>
<body>
<nav class="navbar navbar-dark bg-dark p-3">
    <div class="d-flex col-12 col-md-3 col-lg-2 mb-2 mb-lg-0 flex-wrap flex-md-nowrap justify-content-between">
        <a class="navbar-brand" href="#">
            {{ config('smartyscripts.script_creator') }}
        </a>
        <button class="navbar-toggler d-md-none collapsed mb-3" type="button" data-toggle="collapse"
                data-target="#sidebar" aria-controls="sidebar" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
    </div>
</nav>
<div class="container-fluid">
    <div class="row">
        <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
            <div class="position-sticky">
                <ul class="nav flex-column sidebar-menu">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('install.index') }}">
                            <span class="ml-2">Welcome</span>
                        </a>
                    </li>
                    @for ($i = 1; $i <= config('smartyscripts.total_installation_steps'); $i++)
                        <li class="nav-item">
                            <a class="nav-link @if(session('current_step') < $i)disabled @endif"
                               href="{{ route('install.step' . $i) }}">
                                <span class="ml-2">Step {{ $i }}</span>
                                @if(session('current_step') > $i)
                                    <small><i class="fa fa-check text-success"></i></small>
                                @endif
                            </a>
                        </li>
                    @endfor
                </ul>
                <p class="text-center"><strong>Current Step</strong>: {{ session('current_step') }}</p>
            </div>
        </nav>
        <main class="col-md-9 ml-sm-auto col-lg-10 px-md-4 py-4">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    @if(count($errors) > 1)
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    @else
                        {{$errors->first()}}
                    @endif
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    {{ session('error') }}
                </div>
            @endif
            @yield('content')
            <footer class="pt-5 d-flex justify-content-between">
                <span>Copyright &copy; 2018-{{ date('Y') }} <a href="{{ config('smartyscripts.script_creator_site') }}"
                                                               target="_blank">{{ config('smartyscripts.script_creator') }}</a></span>
                <span>{{ config('smartyscripts.script_name') }} v{{ config('smartyscripts.script_version') }}</span>
            </footer>
        </main>
    </div>
</div>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/5.0.0-alpha1/js/bootstrap.min.js"
        integrity="sha384-oesi62hOLfzrys4LxRF63OJCXdXDipiYWBnvTl9Y9/TRlw5xlKIEHpNyvvDShgf/"
        crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"
        integrity="sha512-Tn2m0TIpgVyTzzvmxLNuqbSJH3JP8jm+Cy3hvHrW7ndTDcJ1w5mBiksqDBb8GpE2ksktFvDB/ykZ0mDpsZj20w=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
@livewireScripts
<script>
    //Active Menu
    (function () {
        let current = location.pathname.split('/')[2];
        if (current === "") return;
        const menuItems = document.querySelectorAll('.sidebar-menu a');
        for (let i = 0, len = menuItems.length; i < len; i++) {
            if (menuItems[i].getAttribute("href") === location.href) {
                let menuItem = menuItems[i];
                menuItem.classList.add('active');
                menuItem.setAttribute('aria-current', 'page');
            }
        }
    })();

    function copy_url() {
        document.getElementById('url').select();
        document.execCommand('copy');
        const copied = document.getElementById('url_copied');
        copied.style.display = 'block';
        setTimeout(function () {
            copied.style.display = 'none';
        }, 3000);
    }
</script>
@stack('scripts')
</body>
</html>