@extends('install.layout')

@section('content')
    <div class="row">
        <div class="col-12 mb-4 mb-lg-0">
            <div class="card">
                <div class="card-body">
                    <h1 class="h2">{{ $page_title }}</h1>
                    <p>This Setup Wizard will guide you through the installation of your new script. Smarty Scripts thanks you for your purchase and wishes success to your new project using our script.</p>
                    <ul class="list-unstyled">
                        <li><b>Script Name:</b> {{ config('smartyscripts.script_name') }}</li>
                        <li><b>Script Version:</b> v{{ config('smartyscripts.script_version') }}</li>
                        <li><b>Official Site:</b> <a href="{{ config('smartyscripts.script_creator_site') }}" target="_blank">{{ config('smartyscripts.script_creator_site') }}</a></li>
                    </ul>
                    <h5><i class="fa fa-exclamation-circle"></i> Before Proceeding</h5>
                    <p>Before starting the installation process, make sure this is the latest version of this script. Always use the latest version as it will always contain bug fixes and new features. You can check for the latest version on the sales page of this script on our website.</p>
                    <h5><i class="fa fa-book"></i> Documentation</h5>
                    <p>In the Documentation section on our website, you can find important information about this script. Remember to consult this documentation if this is your first time using this script, there is important information on how to install, configure and use this script correctly.</p>
                    <h5><i class="fa fa-wrench"></i> Free Installation</h5>
                    <p>If you purchased this script on our website, you are entitled to the first free installation. If you need help with installation, just contact us to enjoy this benefit.</p>
                   </div>
                <div class="card-footer">
                    <a href="{{route('install.step1')}}" class="btn btn-info">Next <i class="fa fa-caret-right"></i></a>
                </div>
            </div>
        </div>
    </div>
@endsection