@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-12 col-lg-3">UUID</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->uuid }}</dd>
                        <dt class="col-sm-12 col-lg-3">Register Date</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->created_at }}</dd>
                        <dt class="col-sm-12 col-lg-3">Register IP</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->ip }}</dd>
                        <dt class="col-sm-12 col-lg-3">Referral Link Hits</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $item->ref_hits }}</dd>
                        <dt class="col-sm-12 col-lg-3">Balance</dt>
                        <dd class="col-sm-12 col-lg-9">{{ crypto_currency($item->balance) }}</dd>
                        <dt class="col-sm-12 col-lg-3">Hashpower</dt>
                        <dd class="col-sm-12 col-lg-9">{{ $user_hashpower }} {{ setting('hashpower_unit') }}/s | {{ crypto_currency($user_hashpower * setting('daily_profit'), setting('balance_decimals')) }} daily</dd>
                    </dl>
                    <form action="{{ $form_params['action'] }}" method="post">
                        @csrf
                        @method($form_params['method'])
                        <div class="row">
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="wallet">Wallet</label>
                                    <input type="text" class="form-control @error('wallet') is-invalid @enderror" id="wallet" name="wallet" value="{{ $item->wallet ?? old('wallet') }}" placeholder="Wallet">
                                    @error('wallet')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <div class="form-group">
                                    <label for="ref_id">Upline</label>
                                    <select name="ref_id" id="ref_id"
                                            class="form-control @error('ref_id') is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}"
                                                    @if(isset($item->ref_id) && $item->ref_id === $user->id)selected @endif>{{ $user->wallet }}</option>
                                        @endforeach
                                    </select>
                                    @error('ref_id')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="allow_withdrawal">Allowed Withdrawal</label>
                                    <select name="allow_withdrawal" id="allow_withdrawal"
                                            class="form-control @error('allow_withdrawal') is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        <option value="0" @if($item->allow_withdrawal === 0)selected @endif>No
                                        </option>
                                        <option value="1" @if($item->allow_withdrawal === 1)selected @endif>
                                            Yes
                                        </option>
                                    </select>
                                    <small class="form-text">This field will be changed automatically if the user makes a deposit.</small>
                                    @error('allow_withdrawal')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select name="status" id="status"
                                            class="form-control @error('status') is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        <option value="active" @if($item->status === 'active')selected @endif>Active
                                        </option>
                                        <option value="inactive" @if($item->status === 'inactive')selected @endif>
                                            Inactive
                                        </option>
                                        <option value="banned" @if($item->status === 'banned')selected @endif>Banned
                                        </option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-12">
                                <div class="form-group">
                                    <label for="banned_message">Banned Reason</label>
                                    <input type="text"
                                           class="form-control @error('banned_message') is-invalid @enderror"
                                           id="banned_message" name="banned_message"
                                           value="{{ $item->banned_message ?? old('banned_message') }}"
                                           placeholder="Banned Reason">
                                    <small class="form-text">Reason for the ban. User can see this message.</small>
                                    @error('banned_message')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <h4>Admin Comments</h4>
                        <div class="form-group">
                            <label for="comments">Comments</label>
                            <textarea name="comments" id="comments"
                                      class="form-control @error('comments') is-invalid @enderror"
                                      rows="5">{{ $item->comments ?? old('comments') }}</textarea>
                            <small class="form-text">Comments about this user. Only admins can see comments.</small>
                            @error('comments')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-users')disabled="disabled" @endcannot><i class="fa fa-save"></i> {{ $form_params['button_name'] }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Bonus and Penalties</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form action="{{ route('admin.users.bonus', $item->id) }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="type">Type</label>
                                    <select name="type" id="type"
                                            class="form-control @error('type') is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        <option value="bonus">Bonus(Hashpower/Balance)
                                        </option>
                                        <option value="penalty">
                                            Penalty(Balance)
                                        </option>
                                        <option value="others">Others(Hashpower)
                                        </option>
                                    </select>
                                    @error('type')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="hashpower">Hashpower</label>
                                    <div class="input-group">
                                        <input type="number" min="0.01" step="0.01"
                                               class="form-control @error('hashpower') is-invalid @enderror"
                                               id="hashpower" name="hashpower"
                                               value="{{ old('hashpower') }}"
                                               placeholder="Hashpower">
                                        <div class="input-group-append">
                                            <div class="input-group-text">{{ setting('hashpower_unit') }}/s</div>
                                        </div>
                                        @error('hashpower')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <small class="form-text">Fill in if bonus is to increase mining power.</small>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="balance">Balance</label>
                                    <div class="input-group">
                                        <input type="number" step="0.00000001"
                                               class="form-control @error('balance') is-invalid @enderror"
                                               id="balance" name="balance"
                                               value="{{ old('balance') }}"
                                               placeholder="Balance">
                                        <div class="input-group-append">
                                            <div class="input-group-text">{{ setting('currency_code') }}</div>
                                        </div>
                                        @error('balance')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <small class="form-text">Fill in if the bonus is to increase/debit the balance.</small>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <input type="text"
                                           class="form-control @error('description') is-invalid @enderror"
                                           id="description" name="description"
                                           value="{{ old('description') }}"
                                           placeholder="Description">
                                    <small class="form-text">Describe the reason. If increasing/debiting balance, include the amount.</small>
                                    @error('description')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary" @cannot('edit-users')disabled="disabled" @endcannot><i class="fa fa-plus-circle"></i> Create</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Statistics</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-lg-6 col-sm-12">
                            <div class="card">
                                <div class="card-header bg-primary"><h5><i class="fa fa-piggy-bank"></i> Deposits</h5></div>
                                <div class="card-body">{{ crypto_currency($statistics->paid_deposits) }}</div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <div class="card">
                                <div class="card-header bg-danger"><h5><i class="fa fa-hand-holding-usd"></i> Withdrawals</h5></div>
                                <div class="card-body">{{ crypto_currency($statistics->paid_withdrawals) }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Logs</h3>
                    <small class="float-right clearfix" title="Current Time"><i class="fa fa-clock"></i> {{ date('Y-m-d H:i:s') }}</small>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped history-table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Type</th>
                                <th>Description</th>
                                <th>Power</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Mining Plans</h3>
                    <small class="float-right clearfix" title="Current Time"><i class="fa fa-clock"></i> {{ date('Y-m-d H:i:s') }}</small>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped plans-table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Power</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Expire Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Deposits History</h3>
                    <small class="float-right clearfix" title="Current Time"><i class="fa fa-clock"></i> {{ date('Y-m-d H:i:s') }}</small>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped deposits-table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Amount</th>
                                <th>Paid Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Withdrawals History</h3>
                    <small class="float-right clearfix" title="Current Time"><i class="fa fa-clock"></i> {{ date('Y-m-d H:i:s') }}</small>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped withdrawals-table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Amount</th>
                                <th>Fees</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('additional_styles')
    <link rel="stylesheet" href="{{ asset('assets/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.css') }}">
@endpush
@push('additional_scripts')
    <script src="//cdn.datatables.net/1.11.0/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/1.11.0/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript">
        $(function () {
            const deposits_table = $('.deposits-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.users.datatables.deposits', $item->id) }}",
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'amount', name: 'amount'},
                    {data: 'paid_amount', name: 'paid_amount'},
                    {data: 'status', name: 'status'},
                    {data: 'created_at', name: 'created_at'},
                ]
            });
            const withdrawals_table = $('.withdrawals-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.users.datatables.withdrawals', $item->id) }}",
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'amount', name: 'amount'},
                    {data: 'fees', name: 'fees'},
                    {data: 'paid_amount', name: 'paid_amount'},
                    {data: 'status', name: 'status'},
                    {data: 'created_at', name: 'created_at'},
                ]
            });
            const history_table = $('.history-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.users.datatables.history', $item->id) }}",
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'type', name: 'type'},
                    {data: 'description', name: 'description'},
                    {data: 'power', name: 'power'},
                    {data: 'created_at', name: 'created_at'},
                ]
            });
            const plans_table = $('.plans-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.users.datatables.plans', $item->id) }}",
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'power', name: 'power'},
                    {data: 'status', name: 'status'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'expire_date', name: 'expire_date'},
                ]
            });
        });
    </script>
@endpush
