@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <form action="{{ $form_params['action'] }}" method="post">
                        @csrf
                        @method($form_params['method'])
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ $item->name ?? old('name') }}" placeholder="Name">
                            @error('name')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="css_class">CSS Class</label>
                            <input type="text" class="form-control @error('css_class') is-invalid @enderror" id="css_class" name="css_class" value="{{ $item->css_class ?? old('css_class') }}" placeholder="CSS Class">
                            <small class="form-text">CSS class to define badge color. Reference colors <a href="https://getbootstrap.com/docs/4.6/components/badge/" target="_blank">here</a>. Eg: primary, secondary, success, danger, warning, danger, info, dark, light</small>
                            @error('css_class')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="default">Default</label>
                            <select name="default" id="default" class="form-control @error('default') is-invalid @enderror">
                                <option value="">-- Select --</option>
                                <option value="0" @if(isset($item) && $item->default === 0)selected @endif>No</option>
                                <option value="1" @if(isset($item) && $item->default === 1)selected @endif>Yes</option>
                            </select>
                            <small class="form-text">Defines if this is the default status when creating a new ticket</small>
                            @error('default')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-ticket-status')disabled="disabled" @endcannot><i class="fa fa-save"></i> {{ $form_params['button_name'] }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
