@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Ticket List</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Title</th>
                                <th scope="col">Category</th>
                                <th scope="col">Priority</th>
                                <th scope="col">Status</th>
                                <th scope="col">Unread</th>
                                <th scope="col">Date</th>
                                <th scope="col">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($items as $item)
                                <tr>
                                    <th scope="row">{{ $item->id }}</th>
                                    <td>{{ $item->title }}</td>
                                    <td>{{ $item->category->name }}</td>
                                    <td><span class="badge badge-{{ $item->priority->css_class ?? 'primary' }}">{{ $item->priority->name }}</span></td>
                                    <td><span class="badge badge-{{ $item->status->css_class ?? 'primary' }}">{{ $item->status->name }}</span></td>
                                    <td>
                                        @if ($item->admin_read)
                                            <span class="badge badge-success">Read</span>
                                        @else
                                            <span class="badge badge-danger">Unread</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->created_at }}</td>
                                    <td>
                                        <form action="{{ route('admin.tickets.destroy', $item->id) }}" method="post" onsubmit="return confirm('Are you sure you want to delete this record?')">
                                            @csrf
                                            @method('delete')
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.tickets.edit', $item->id) }}" class="btn btn-info @cannot('show-tickets')disabled @endcannot"><i class="fa fa-edit"></i> Edit</a>
                                                <button type="submit" class="btn btn-danger" @cannot('delete-tickets')disabled="disabled" @endcannot><i class="fa fa-trash"></i> Delete</button>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center">No results found!</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $items->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection