@extends('layouts.admin.default')
@php $plugin['wysiwyg'] = true; @endphp
@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ $page_title }}</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-lg-3 col-sm-12">Created At:</dt>
                        <dd class="col-lg-9 col-sm-12">{{ $item->created_at }}</dd>
                        <dt class="col-lg-3 col-sm-12">Updated At:</dt>
                        <dd class="col-lg-9 col-sm-12">{{ $item->updated_at }}</dd>
                        <dt class="col-lg-3 col-sm-12">Message:</dt>
                        <dd class="col-lg-9 col-sm-12">{{ $item->message }}</dd>
                    </dl>
                    <form action="{{ $form_params['action'] }}" method="post">
                        @csrf
                        @method($form_params['method'])
                        <div class="row">
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select id="category_id" name="category_id" class="form-control @error('category_id')is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        @foreach($categories as $category)
                                            <option value="{{$category->id}}" @if($category->id===$item->category_id)selected @endif>{{$category->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="priority_id">Priority</label>
                                    <select id="priority_id" name="priority_id" class="form-control @error('priority_id')is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        @foreach($priorities as $priority)
                                            <option value="{{$priority->id}}" @if($priority->id===$item->priority_id)selected @endif>{{$priority->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('priority_id')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="status_id">Status</label>
                                    <select id="status_id" name="status_id" class="form-control @error('status_id')is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        @foreach($statuses as $status)
                                            <option value="{{$status->id}}" @if($status->id===$item->status_id)selected @endif>{{$status->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('status_id')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-12">
                                <div class="form-group">
                                    <label for="admin_read">Unread/Read</label>
                                    <select id="admin_read" name="admin_read" class="form-control @error('admin_read')is-invalid @enderror">
                                        <option value="">-- Select --</option>
                                        <option value="0" @if(!$item->admin_read)selected @endif>Unread</option>
                                        <option value="1" @if($item->admin_read)selected @endif>Read</option>
                                    </select>
                                    @error('admin_read')
                                    <div class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-tickets')disabled="disabled" @endcannot><i class="fa fa-save"></i> {{ $form_params['button_name'] }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <!-- DIRECT CHAT -->
            <div class="card direct-chat direct-chat-primary">
                <div class="card-header">
                    <h3 class="card-title">Comments</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <!-- Conversations are loaded here -->
                    <div class="direct-chat-messages">
                        @forelse ($item->comments()->with('user','admin')->get() as $comment)
                            @if($comment->user_id)
                                <!-- Message. Default to the left -->
                                <div class="direct-chat-msg">
                                    <div class="direct-chat-infos clearfix">
                                        <span class="direct-chat-name float-left">{{ $comment->user->wallet }} <a
                                                    href="{{ route('admin.users.edit', $comment->user_id) }}" title="Edit user"><i class="fa fa-link"></i></a></span>
                                        <span class="direct-chat-timestamp float-right">{{ $comment->created_at }}</span>
                                    </div>
                                    <!-- /.direct-chat-infos -->
                                    <div class="direct-chat-text ml-1">
                                        {{ $comment->comment }}
                                    </div>
                                    <!-- /.direct-chat-text -->
                                </div>
                                <!-- /.direct-chat-msg -->
                            @else
                                <!-- Message to the right -->
                                <div class="direct-chat-msg right">
                                    <div class="direct-chat-infos clearfix">
                                        <span class="direct-chat-name float-right">{{ $comment->admin->username }}</span>
                                        <span class="direct-chat-timestamp float-left">{{ $comment->created_at }}</span>
                                    </div>
                                    <!-- /.direct-chat-infos -->
                                    <div class="direct-chat-text mr-1">
                                        {{ $comment->comment }}
                                    </div>
                                    <!-- /.direct-chat-text -->
                                </div>
                                <!-- /.direct-chat-msg -->
                            @endif
                        @empty
                            <span>No comments found!</span>
                        @endforelse

                    </div>
                    <!--/.direct-chat-messages-->
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <form action="{{ route('admin.tickets.comment', $item->id) }}" method="post">
                        @csrf
                        <div class="input-group">
                            <input type="text" name="comment" placeholder="Type Message ..." class="form-control @error('comment')is-invalid @enderror">
                            <span class="input-group-append">
                              <button type="submit" class="btn btn-primary" @cannot('edit-tickets')disabled="disabled" @endcannot>Send</button>
                            </span>
                            @error('comment')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                    </form>
                </div>
                <!-- /.card-footer-->
            </div>
            <!--/.direct-chat -->
        </div>
    </div>
@endsection
