@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fa fa-sync-alt"></i> Update Script</h3>
                </div>
                <div class="card-body">
                    <p>If you have downloaded an update package, use the field below to select the zip file and click the button to apply the update to your website.</p>
                    <div class="alert alert-danger"><strong>Warning</strong>: if you have modified any files, when applying an update package the modifications you have made may be lost if one or more files contained in the update package are one of the files you have modified. If this is your case, you should compare the changes contained in the new files with the previous version, this way you can reapply the changes you made previously to the new files.</div>
                    <h4>Important Tips</h4>
                    <ol>
                        <li>You can download update packages from the Downloads section of your account on the <a
                                    href="{{ config('smartyscripts.script_creator_site') }}" target="_blank">{{ config('smartyscripts.script_creator') }}</a> website.</li>
                        <li>Remember to download only the update package(eg: {{ config('smartyscripts.script_name') }} Patch v1.0.1.zip), don't try to update your website using the installer file(eg: {{ config('smartyscripts.script_name') }} v1.0.1.zip), or your website may crash and you will need to reinstall again.</li>
                        <li>Always apply one update package at a time, following ascending order from the current version of your script. Example: if you are using version 1.0.0 and there is an update to version 1.0.5, see if there are updates 1.0.1/1.0.2/1.0.3/1.0.4 and apply each one in ascending order, before applying version 1.0.5. The latest update packages do not contain previous updates, so you must apply each one separately.</li>
                        <li class="text-danger">It is recommended that you turn on <strong>Maintenance Mode</strong> before performing an upgrade to prevent users from using the site during the upgrade process.</li>
                    </ol>
                    <p class="text-danger"></p>
                    <form action="{{ route('admin.update_script') }}" enctype="multipart/form-data" method="post">
                        @csrf
                        <div class="form-group">
                            <label for="update_patch">Update Patch</label>
                            <input type="file" accept="application/zip" class="form-control-file @error('update_patch') is-invalid @enderror" id="update_patch" name="update_patch" placeholder="Update Patch" @cannot('update-script')disabled="disabled" @endcannot>
                            <small class="form-text"><strong>Format</strong>: ZIP</small>
                            @error('update_patch')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('update-script')disabled="disabled" @endcannot><i class="fa fa-upload"></i> Update Now</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('additional_styles')
    <!--Color Picker-->
    <link rel="stylesheet" href="{{ asset('assets/admin/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css') }}">
@endpush
@push('additional_scripts')
    <!--Color Picker-->
    <script src="{{ asset('assets/admin/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js') }}"></script>
    <script>
        $(".color-picker-input").colorpicker({
            format: 'hex',
            component: '.input-group-append',
        });
        $('.color-picker-input').on('colorpickerChange', function(event) {
            this.nextElementSibling.querySelector('.fa-square').style.color = event.color.toString();
        });
    </script>
@endpush