@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><i class="fa fa-cog"></i> Settings</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.settings.clear_cache') }}" class="btn btn-sm btn-danger" title="Clear all cached data"><i class="fa fa-brush"></i> Clear Cache</a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="general-tab" data-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">General</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="configs-tab" data-toggle="tab" href="#configs" role="tab" aria-controls="configs" aria-selected="false">Configs</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="gateways-tab" data-toggle="tab" href="#gateways" role="tab" aria-controls="gateways" aria-selected="false">Gateways</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="seo-tab" data-toggle="tab" href="#seo" role="tab" aria-controls="seo" aria-selected="false">SEO</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="company-tab" data-toggle="tab" href="#company" role="tab" aria-controls="company" aria-selected="false">Company</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="social-tab" data-toggle="tab" href="#social" role="tab" aria-controls="social" aria-selected="false">Social</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="cookies-tab" data-toggle="tab" href="#cookies" role="tab" aria-controls="cookies" aria-selected="false">Cookie Consent</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="design-tab" data-toggle="tab" href="#design" role="tab" aria-controls="design" aria-selected="false">Design</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="maintenance-tab" data-toggle="tab" href="#maintenance" role="tab" aria-controls="maintenance" aria-selected="false">Maintenance</a>
                        </li>
                    </ul>
                    <form action="{{ route('admin.settings') }}" method="post">
                        @csrf
                        <!-- Tab panes -->
                        <div class="tab-content mt-2">
                            <div class="tab-pane active" id="general" role="tabpanel" aria-labelledby="general-tab">
                                @include('admin.settings.general')
                            </div>
                            <div class="tab-pane" id="configs" role="tabpanel" aria-labelledby="configs-tab">
                                @include('admin.settings.configs')
                            </div>
                            <div class="tab-pane" id="gateways" role="tabpanel" aria-labelledby="gateways-tab">
                                @include('admin.settings.gateways')
                            </div>
                            <div class="tab-pane" id="seo" role="tabpanel" aria-labelledby="seo-tab">
                                @include('admin.settings.seo')
                            </div>
                            <div class="tab-pane" id="company" role="tabpanel" aria-labelledby="company-tab">
                                @include('admin.settings.company')
                            </div>
                            <div class="tab-pane" id="social" role="tabpanel" aria-labelledby="social-tab">
                                @include('admin.settings.social')
                            </div>
                            <div class="tab-pane" id="cookies" role="tabpanel" aria-labelledby="cookies-tab">
                                @include('admin.settings.cookies')
                            </div>
                            <div class="tab-pane" id="design" role="tabpanel" aria-labelledby="design-tab">
                                @include('admin.settings.design')
                            </div>
                            <div class="tab-pane" id="maintenance" role="tabpanel" aria-labelledby="maintenance-tab">
                                @include('admin.settings.maintenance')
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success" @cannot('edit-settings')disabled="disabled" @endcannot><i class="fa fa-save"></i> Save</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('additional_styles')
    <!--Color Picker-->
    <link rel="stylesheet" href="{{ asset('assets/admin/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css') }}">
    <!--Code Mirror-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/codemirror.min.css" integrity="sha512-6sALqOPMrNSc+1p5xOhPwGIzs6kIlST+9oGWlI4Wwcbj1saaX9J3uzO3Vub016dmHV7hM+bMi/rfXLiF5DNIZg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/theme/dracula.min.css" integrity="sha512-gFMl3u9d0xt3WR8ZeW05MWm3yZ+ZfgsBVXLSOiFz2xeVrZ8Neg0+V1kkRIo9LikyA/T9HuS91kDfc2XWse0K0A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
@endpush
@push('additional_scripts')
    <!--Code Mirror-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/codemirror.min.js" integrity="sha512-XMlgZzPyVXf1I/wbGnofk1Hfdx+zAWyZjh6c21yGo/k1zNC4Ve6xcQnTDTCHrjFGsOrVicJsBURLYktVEu/8vQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/mode/css/css.min.js" integrity="sha512-UB/NeigW3LreuA/sHVVcykCf2FzhzHlk0BpsanfK8VmvvLFLUof1ysy1hCOYhyqlfCY8HW7w8qh/rsUJZLMpIg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/addon/edit/matchbrackets.min.js" integrity="sha512-03Ei8A+mDhwF6O/CmXM47U4A9L7TobAxMbPV2Wn5cEbY76lngHQRyvvmnqhJ8IthfoxrRqmtoBxQCxOC7AOeKw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.63.3/addon/edit/closebrackets.min.js" integrity="sha512-cCnOU69ESswPmMV3f9TR7WgctoJZliqGbJ8WeLn0VlUrngSsmtVopRf6OG/epbURGfNmY4RY6RzZ/mWkPQ/onw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!--Color Picker-->
    <script src="{{ asset('assets/admin/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js') }}"></script>
    <script>
        let customCssSite = CodeMirror.fromTextArea(document.getElementById('custom_css_site'), {
            mode: "text/css",
            theme: 'dracula',
            autoCloseBrackets: true,
            matchBrackets: true,
            showCursorWhenSelecting: true
        });
        let customCssDashboard = CodeMirror.fromTextArea(document.getElementById('custom_css_dashboard'), {
            mode: "text/css",
            theme: 'dracula',
            autoCloseBrackets: true,
            matchBrackets: true,
            showCursorWhenSelecting: true
        });
        $(".color-picker-input").colorpicker({
            format: 'hex',
            component: '.input-group-append',
        });
        $('.color-picker-input').on('colorpickerChange', function(event) {
            this.nextElementSibling.querySelector('.fa-square').style.color = event.color.toString();
        });
    </script>
@endpush