<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="force_https">Force HTTPS</label>
            <select name="force_https" id="force_https" class="form-control @error('force_https') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="enabled" @if(setting('force_https') === 'enabled')selected @endif>Enabled</option>
                <option value="disabled" @if(setting('force_https') === 'disabled')selected @endif>Disabled</option>
            </select>
            <small class="form-text">Enable this option if you have problems displaying data in the admin panel.</small>
            @error('force_https')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="multiple_accounts">Allow Multiple Accounts</label>
            <select name="multiple_accounts" id="multiple_accounts" class="form-control @error('multiple_accounts') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="yes" @if(setting('multiple_accounts') === 'yes')selected @endif>Yes</option>
                <option value="no" @if(setting('multiple_accounts', 'no') === 'no')selected @endif>No</option>
            </select>
            <small class="form-text">Allow or not allow users to create more than one account per IP.</small>
            @error('multiple_accounts')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="header_codes">Header Codes</label>
            <textarea class="form-control @error('header_codes') is-invalid @enderror" id="header_codes" name="header_codes" rows="5" placeholder="Header Codes">{{ setting('header_codes') }}</textarea>
            @error('header_codes')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="footer_codes">Footer Codes</label>
            <textarea class="form-control @error('footer_codes') is-invalid @enderror" id="footer_codes" name="footer_codes" rows="5" placeholder="Footer Codes">{{ setting('footer_codes') }}</textarea>
            @error('footer_codes')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
