<img src="{{ asset('assets/admin/gateways/paykassa.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://paykassa.pro/en/?rid=5996" target="_blank" title="Open in new tab/window">https://paykassa.pro  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Supported Coins</strong>: <a href="https://paykassa.pro/en/accept/?rid=5996" target="_blank" title="Open in new tab/window">https://paykassa.pro/en/accept/  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Min. Deposits/Withdrawals: </strong> <a href="https://paykassa.pro/en/accept/?rid=5996" target="_blank" title="Open in new tab/window">https://paykassa.pro/en/accept/  <i class="fa fa-external-link-alt"></i></a></li>
</ul>
<p><strong>Warning</strong>: Log into your account and set the "Accept any amount" field (merchants->settings->technical) to "no".</p>
<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_timeout">Deposit Timeout</label>
            <div class="input-group">
                <input type="number" step="1" min="0" class="form-control @error('paykassa_timeout') is-invalid @enderror" id="paykassa_timeout" name="paykassa_timeout" value="{{ setting('paykassa_timeout') }}" placeholder="Deposit Timeout">
                <div class="input-group-append">
                    <div class="input-group-text">hours</div>
                </div>
                @error('paykassa_timeout')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">How many hours does the user have to make the deposit after generating the payment address.</small>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_confirmations">Confirmations Required</label>
            <input type="number" step="1" min="0" class="form-control @error('paykassa_confirmations') is-invalid @enderror" id="paykassa_confirmations" name="paykassa_confirmations" value="{{ setting('paykassa_confirmations') }}" placeholder="Confirmations Required">
            <small class="form-text">Confirmations required to accept payments.</small>
            @error('paykassa_confirmations')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_mid">Merchant ID</label>
            <input type="text" name="paykassa_mid" id="paykassa_mid" placeholder="Paykassa Merchant ID" class="form-control @error('paykassa_mid')is-invalid @enderror" value="{{ setting_field('paykassa_mid') }}">
            <small class="form-text">Click <a href="https://paykassa.pro/en/user/shops/?rid=5996" target="_blank">here</a> to get your merchant id</small>
            @error('paykassa_mid')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_secret">Merchant Secret Key</label>
            <input type="text" name="paykassa_secret" id="paykassa_secret" placeholder="Paykassa Secret Key" class="form-control @error('paykassa_secret')is-invalid @enderror" value="{{ setting_field('paykassa_secret') }}">
            <small class="form-text">Click <a href="https://paykassa.pro/en/user/shops/?rid=5996" target="_blank">here</a> to get your merchant secret key</small>
            @error('paykassa_secret')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_api_currency">API Currency</label>
            <select class="form-control @error('paykassa_api_currency')is-invalid @enderror" name="paykassa_api_currency" id="paykassa_api_currency">
                <option value="">-- Select --</option>
                <option value="bitcoin" @if(setting('paykassa_api_currency')==='bitcoin') selected @endif>Bitcoin</option>
                <option value="ethereum" @if(setting('paykassa_api_currency')==='ethereum') selected @endif>Ethereum</option>
                <option value="litecoin" @if(setting('paykassa_api_currency')==='litecoin') selected @endif>Litecoin</option>
                <option value="dogecoin" @if(setting('paykassa_api_currency')==='dogecoin') selected @endif>Dogecoin</option>
                <option value="dash" @if(setting('paykassa_api_currency')==='dash') selected @endif>Dash</option>
                <option value="bitcoincash" @if(setting('paykassa_api_currency')==='bitcoincash') selected @endif>BitcoinCash</option>
                <option value="zcash" @if(setting('paykassa_api_currency')==='zcash') selected @endif>Zcash</option>
                <option value="ripple" @if(setting('paykassa_api_currency')==='ripple') selected @endif>Ripple</option>
                <option value="tron" @if(setting('paykassa_api_currency')==='tron') selected @endif>Tron</option>
                <option value="stellar" @if(setting('paykassa_api_currency')==='stellar') selected @endif>Stellar</option>
                <option value="binancecoin" @if(setting('paykassa_api_currency')==='binancecoin') selected @endif>BinanceCoin (BNB)</option>
                <option value="tron_trc20" @if(setting('paykassa_api_currency')==='tron_trc20') selected @endif>Tron TRC20 (USDT)</option>
                <option value="binancesmartchain_bep20" @if(setting('paykassa_api_currency')==='binancesmartchain_bep20') selected @endif>BEP20(USDT, BUSD, USDC, ADA, EOS, BTC, ETH, DOGE)</option>
                <option value="ethereum_erc20" @if(setting('paykassa_api_currency')==='ethereum_erc20') selected @endif>Ethereum ERC20(USDT)</option>
            </select>
            <small class="form-text">API Currency</small>
            @error('paykassa_api_currency')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_api_id">API ID</label>
            <input type="text" name="paykassa_api_id" id="paykassa_api_id" placeholder="Paykassa API ID" class="form-control @error('paykassa_api_id')is-invalid @enderror" value="{{ setting_field('paykassa_api_id') }}">
            <small class="form-text">Click <a href="https://paykassa.pro/en/user/api/?rid=5996" target="_blank">here</a> to get your api id</small>
            @error('paykassa_api_id')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_api_secret">API Secret</label>
            <input type="text" name="paykassa_api_secret" id="paykassa_api_secret" placeholder="Paykassa API Secret" class="form-control @error('paykassa_api_secret')is-invalid @enderror" value="{{ setting_field('paykassa_api_secret') }}">
            <small class="form-text">Click <a href="https://paykassa.pro/en/user/api/?rid=5996" target="_blank">here</a> to get your api secret</small>
            @error('paykassa_api_secret')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_api_priority">Priority</label>
            <select class="form-control @error('paykassa_api_priority')is-invalid @enderror" name="paykassa_api_priority" id="paykassa_api_priority">
                <option value="slow" @if(setting('paykassa_api_priority')==='slow') selected @endif>Slow</option>
                <option value="medium" @if(setting('paykassa_api_priority')==='medium') selected @endif>Medium (default)</option>
                <option value="high" @if(setting('paykassa_api_priority')==='high') selected @endif>High</option>
            </select>
            <small class="form-text">Priority of transaction processing</small>
            @error('paykassa_api_priority')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="paykassa_fee">Withdraw Fees</label>
            <select class="form-control @error('paykassa_fee') is-invalid @enderror" name="paykassa_fee" id="paykassa_fee">
                <option value="">-- Select --</option>
                <option value="0"
                        @if(setting('paykassa_fee')==='0') selected @endif>User(default)
                </option>
                <option value="1"
                        @if(setting('paykassa_fee')==='1') selected @endif>
                    Admin
                </option>
            </select>
            <small class="form-text">Who pays Withdrawal fees.</small>
            @error('paykassa_fee')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
<div class="form-group">
    <label for="paykassa_handler">URL notifications about the payment of the invoice [sci_confirm_order]</label>
    <input type="url" id="paykassa_handler" class="form-control" readonly value="{{ route('ipn.paykassa_success') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="paykassa_success">URL Pages with a message about successful payment [redirect]</label>
    <input type="url" id="paykassa_success" class="form-control" readonly value="{{ route('ipn.success') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="paykassa_fail">URL Pages with a failure message when paying [redirect]</label>
    <input type="url" id="paykassa_fail" class="form-control" readonly value="{{ route('ipn.fail') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="paykassa_handler">URL processing processor of cryptocurrencies (optional) [sci_confirm_transaction_notification]</label>
    <input type="url" id="paykassa_handler" class="form-control" readonly value="{{ route('ipn.paykassa') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="paykassa_handler">Accept any amount: <strong>NO</strong></label>
</div>