<img src="{{ asset('assets/admin/gateways/coinpayments.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://hspay.io" target="_blank" title="Open in new tab/window">https://hspay.io  <i class="fa fa-external-link-alt"></i></a></li>
</ul>
<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_merchant_api_key">Merchant API Key (Deposits)</label>
            <input type="text" name="hspay_merchant_api_key" id="hspay_merchant_api_key" placeholder="Merchant API Key"
                   class="form-control @error('hspay_merchant_api_key')is-invalid @enderror"
                   value="{{ old('hspay_merchant_api_key', setting_field('hspay_merchant_api_key')) }}">
            <small class="form-text">Your HSPay Merchant API key for receiving payments (deposits)</small>
            @error('hspay_merchant_api_key')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_faucet_api_key">Faucet API Key (Withdrawals)</label>
            <input type="text" name="hspay_faucet_api_key" id="hspay_faucet_api_key" placeholder="Faucet API Key"
                   class="form-control @error('hspay_faucet_api_key')is-invalid @enderror"
                   value="{{ old('hspay_faucet_api_key', setting_field('hspay_faucet_api_key')) }}">
            <small class="form-text">Your HSPay Faucet API key for sending payments (withdrawals)</small>
            @error('hspay_faucet_api_key')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_crypto2">Forced Crypto (optional)</label>
            <input type="text" name="hspay_crypto2" id="hspay_crypto2" placeholder="e.g., BTC"
                   class="form-control @error('hspay_crypto2')is-invalid @enderror"
                   value="{{ setting_field('hspay_crypto2') }}">
            <small class="form-text">If set, buyers are forced to pay with this crypto</small>
            @error('hspay_crypto2')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_base_url">API Base URL</label>
            <input type="url" name="hspay_base_url" id="hspay_base_url" placeholder="https://hspay.io/api/v1"
                   class="form-control @error('hspay_base_url')is-invalid @enderror"
                   value="{{ setting_field('hspay_base_url', 'https://hspay.io/api/v1') }}">
            <small class="form-text">HSPay API base URL (default: https://hspay.io/api/v1)</small>
            @error('hspay_base_url')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_merchant_name">Merchant Name (Username)</label>
            <input type="text" name="hspay_merchant_name" id="hspay_merchant_name" placeholder="Your HSPay username"
                   class="form-control @error('hspay_merchant_name')is-invalid @enderror"
                   value="{{ setting_field('hspay_merchant_name') }}">
            <small class="form-text">Optional: Your HSPay username for webhook validation</small>
            @error('hspay_merchant_name')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="form-group">
            <label for="hspay_user_source">User Identifier Source</label>
            <select name="hspay_user_source" id="hspay_user_source" class="form-control @error('hspay_user_source')is-invalid @enderror">
                <option value="wallet" @if(setting('hspay_user_source','wallet')==='wallet') selected @endif>Wallet Address (Recommended for Withdrawals)</option>
                <option value="email" @if(setting('hspay_user_source')==='email') selected @endif>Email</option>
                <option value="username" @if(setting('hspay_user_source')==='username') selected @endif>Username</option>
            </select>
            <small class="form-text">Which user field to send as HSPay "user" parameter. <strong>Wallet is recommended for withdrawals.</strong></small>
            @error('hspay_user_source')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

