<img src="{{ asset('assets/admin/gateways/cryptapi.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://cryptapi.io" target="_blank" title="Open in new tab/window">
            https://cryptapi.io <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Supported Coins</strong>: <a href="https://cryptapi.io/pricing" target="_blank" title="Open in new tab/window">https://cryptapi.io/pricing  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Min. Deposits: </strong> <a href="https://cryptapi.io/pricing" target="_blank" title="Open in new tab/window">https://cryptapi.io/pricing  <i class="fa fa-external-link-alt"></i></a></li>
</ul>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="cryptapi_wallet">Wallet Address</label>
            <input type="text" name="cryptapi_wallet" id="cryptapi_wallet" placeholder="Wallet Address"
                   class="form-control @error('cryptapi_wallet')is-invalid @enderror"
                   value="{{ setting_field('cryptapi_wallet') }}">
            <small class="form-text">Address where the payment will be forwarded to.</small>
            @error('cryptapi_wallet')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="cryptapi_network">Currency Network</label>
            <select class="form-control @error('cryptapi_network')is-invalid @enderror" name="cryptapi_network" id="cryptapi_network">
                <option value="crypto" @if(setting('cryptapi_network')==='crypto') selected @endif>Cryptocurrencies(BTC, ETH, BCH, LTC, MIOTA, XMR, TRX)</option>
                <option value="erc20" @if(setting('cryptapi_network')==='erc20') selected @endif>ERC-20 Tokens</option>
                <option value="bep20" @if(setting('cryptapi_network')==='bep20') selected @endif>BEP-20 Tokens</option>
                <option value="trc20" @if(setting('cryptapi_network')==='trc20') selected @endif>TRC-20 Tokens</option>
            </select>
            <small class="form-text">Currency network. Bitcoin, ERC20, TRC20, BEP20. See the list <a href="https://cryptapi.io/pricing/" target="_blank">here</a>.</small>
            @error('cryptapi_network')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="cryptapi_timeout">Deposit Timeout</label>
            <div class="input-group">
                <input type="number" step="1" min="0" class="form-control @error('cryptapi_timeout') is-invalid @enderror" id="cryptapi_timeout" name="cryptapi_timeout" value="{{ setting('cryptapi_timeout') }}" placeholder="Deposit Timeout">
                <div class="input-group-append">
                    <div class="input-group-text">hours</div>
                </div>
                @error('cryptapi_timeout')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">How many hours does the user have to make the deposit after generating the payment address.</small>
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="cryptapi_confirmations">Confirmations Required</label>
            <input type="number" step="1" min="0" class="form-control @error('cryptapi_confirmations') is-invalid @enderror" id="cryptapi_confirmations" name="cryptapi_confirmations" value="{{ setting('cryptapi_confirmations') }}" placeholder="Confirmations Required">
            <small class="form-text">Confirmations required to accept payments.</small>
            @error('cryptapi_confirmations')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>