<img src="{{ asset('assets/admin/gateways/coinpayments.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://www.coinpayments.net/?ref=c69dfbdb0d8eedb2d5e7180b85d1e0b9" target="_blank" title="Open in new tab/window">https://www.coinpayments.net  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Supported Coins: </strong> <a href="https://www.coinpayments.net/supported-coins?ref=c69dfbdb0d8eedb2d5e7180b85d1e0b9" target="_blank" title="Open in new tab/window">https://www.coinpayments.net/supported-coins  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Min. Deposits/Withdrawals: </strong> Access your account, go to the withdrawal/deposit page (of the currency you intend to use) and see the minimum amount</li>
</ul>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="coinpayments_pvk">Coinpayments Private Key</label>
            <input type="text" name="coinpayments_pvk" id="coinpayments_pvk" placeholder="Coinpayments Private Key"
                   class="form-control @error('coinpayments_pbk')is-invalid @enderror"
                   value="{{ setting_field('coinpayments_pvk', 'PRIVATEKEY') }}">
            <small class="form-text">Click <a
                        href="https://www.coinpayments.net/acct-api-keys"
                        target="_blank">here</a> to get your key</small>
            @error('coinpayments_pvk')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="coinpayments_pbk">Coinpayments Public Key</label>
            <input type="text" name="coinpayments_pbk" id="coinpayments_pbk" placeholder="Coinpayments Public Key"
                   class="form-control @error('coinpayments_pbk')is-invalid @enderror"
                   value="{{ setting_field('coinpayments_pbk', 'PUBLICKEY') }}">
            <small class="form-text">Click <a
                        href="https://www.coinpayments.net/acct-api-keys"
                        target="_blank">here</a> to get your key</small>
            @error('coinpayments_pbk')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="coinpayments_mode">Coinpayments Deposit Mode</label>
            <select class="form-control @error('coinpayments_mode')is-invalid @enderror" name="coinpayments_mode" id="coinpayments_mode">
                <option value="gateway" @if(setting('coinpayments_mode')==='gateway') selected @endif>Gateway</option>
                <option value="api" @if(setting('coinpayments_mode')==='api') selected @endif>API</option>
            </select>
            <small class="form-text"><strong>Gateway</strong>: redirect to Coinpayments. <strong>API</strong>: generate deposit address with QrCode</small>
            @error('coinpayments_mode')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="coinpayments_email">Coinpayments Invoice Email</label>
            <select class="form-control @error('coinpayments_email')is-invalid @enderror" name="coinpayments_email" id="coinpayments_email">
                <option value="admin" @if(setting('coinpayments_email')==='admin') selected @endif>Admin(default)</option>
                <option value="user" @if(setting('coinpayments_email')==='user') selected @endif>User</option>
            </select>
            <small class="form-text">Use the user or admin email to create payment addresses and make payments.</small>
            @error('coinpayments_email')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="coinpayments_fee">Withdraw Fees</label>
            <select class="form-control @error('coinpayments_fee') is-invalid @enderror" name="coinpayments_fee" id="coinpayments_fee">
                <option value="">-- Select --</option>
                <option value="0"
                        @if(setting('coinpayments_fee')==='0' || old('coinpayments_fee', 0) == '0') selected @endif>User(default)
                </option>
                <option value="1"
                        @if(setting('coinpayments_fee')==='1' || old('coinpayments_fee') == '1') selected @endif>
                    Admin
                </option>
            </select>
            <small class="form-text">Who pays Withdrawal fees.</small>
            @error('coinpayments_fee')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="coinpayments_mid">Coinpayments Merchant ID</label>
            <input type="text" name="coinpayments_mid" id="coinpayments_mid" placeholder="Coinpayments Merchant ID"
                   class="form-control @error('coinpayments_mid')is-invalid @enderror"
                   value="{{ setting_field('coinpayments_mid', 'MERCHANT') }}">
            <small class="form-text">Click <a
                        href="https://www.coinpayments.net/acct-settings"
                        target="_blank">here</a>. Can be found on 'Basic Settings' tab.</small>
            @error('coinpayments_mid')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="coinpayments_ipn">Coinpayments Secret IPN</label>
            <input type="text" name="coinpayments_ipn" id="coinpayments_ipn" placeholder="Coinpayments Secret IPN"
                   class="form-control @error('coinpayments_ipn')is-invalid @enderror"
                   value="{{ setting_field('coinpayments_ipn', 'IPNSECRET') }}">
            <small class="form-text">Click <a
                        href="https://www.coinpayments.net/acct-settings"
                        target="_blank">here</a>. Set this on 'Merchant Settings' tab, IPN
                Secret Key.</small>
            @error('coinpayments_ipn')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>