<img src="{{ asset('assets/admin/gateways/coingate.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://coingate.com/ref/SmartyScripts?destination=accept" target="_blank" title="Open in new tab/window">
            https://coingate.com  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Supported Coins</strong>: <a href="https://coingate.com/supported-currencies" target="_blank" title="Open in new tab/window">https://coingate.com/supported-currencies  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Min. Deposits: </strong> 0.1 EUR</li>
</ul>
<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="coingate_mode">CoinGate Mode</label>
            <select class="form-control @error('coingate_mode')is-invalid @enderror" name="coingate_mode" id="coingate_mode">
                <option value="">-- Select --</option>
                <option value="live" @if(setting('coingate_mode')==='live') selected @endif>
                    Live
                </option>
                <option value="sandbox"
                        @if(setting('coingate_mode')==='sandbox') selected @endif>Sandbox
                </option>
            </select>
            <small class="form-text">CoinGate mode(live or sandbox)</small>
            @error('coingate_mode')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="coingate_auth_token">CoinGate Auth Token</label>
            <input type="text" name="coingate_auth_token" id="coingate_auth_token" placeholder="CoinGate Auth Token"
                   class="form-control @error('coingate_auth_token')is-invalid @enderror"
                   value="{{ setting_field('coingate_auth_token') }}">
            <small class="form-text">CoinGate Auth Token</small>
            @error('coingate_auth_token')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="coingate_receive">CoinGate Receive Currency</label>
            <input type="text" name="coingate_receive" id="coingate_receive" placeholder="CoinGate Receive Currency"
                   class="form-control @error('coingate_receive')is-invalid @enderror"
                   value="{{ setting('coingate_receive') }}">
            </select>
            <small class="form-text">CoinGate Receive Currency. Read more <a href="https://developer.coingate.com/docs/create-order" target="_blank">here</a>. Default: DO_NOT_CONVERT</small>
            @error('coingate_receive')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
<div class="form-group">
    <label for="coingate_handler">Notification URL</label>
    <input type="url" id="coingate_handler" class="form-control" readonly value="{{ route('ipn.coingate') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="coingate_success">Success URL</label>
    <input type="url" id="coingate_success" class="form-control" readonly value="{{ route('ipn.success') }}" onclick="this.select();">
</div>
<div class="form-group">
    <label for="coingate_fail">Fail URL</label>
    <input type="url" id="coingate_fail" class="form-control" readonly value="{{ route('ipn.fail') }}" onclick="this.select();">
</div>