<img src="{{ asset('assets/admin/gateways/blockio.png') }}" alt="" class="img-thumbnail" style="width:100px">
<ul class="list-unstyled">
    <li><strong>Official Site</strong>: <a href="https://www.block.io/" target="_blank" title="Open in new tab/window">https://www.block.io  <i class="fa fa-external-link-alt"></i></a></li>
    <li><strong>Supported Coins: </strong> Bitcoin, Dogecoin, Litecoin</li>
    <li><strong>Min. Withdrawals: </strong> 2 DOGE, 0.00002 BTC, 0.0002 LTC</li>
</ul>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="blockio_mode">Block.io Mode</label>
            <select class="form-control @error('blockio_mode') is-invalid @enderror" name="blockio_mode" id="blockio_mode">
                <option value="">-- Select --</option>
                <option value="live" @if(setting('blockio_mode')==='live') selected @endif>Live</option>
                <option value="test" @if(setting('blockio_mode')==='test') selected @endif>Testnet</option>
            </select>
            <small class="form-text">Block.io mode(live or test). <strong class="text-danger">Warning</strong>: when
                using Testnet mode, before switching to Live mode, delete all transactions with addresses from the
                TESTNET network to avoid errors.</small>
            @error('blockio_mode')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="blockio_withdrawal_fee">Withdraw Fees</label>
            <select class="form-control @error('blockio_withdrawal_fee') is-invalid @enderror" name="blockio_withdrawal_fee" id="blockio_withdrawal_fee">
                <option value="">-- Select --</option>
                <option value="user"
                        @if(setting('blockio_withdrawal_fee')==='user') selected @endif>User(default)
                </option>
                <option value="admin"
                        @if(setting('blockio_withdrawal_fee')==='admin') selected @endif>
                    Admin
                </option>
            </select>
            <small class="form-text">Who pays Withdrawal fees.</small>
            @error('blockio_withdrawal_fee')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="blockio_pin">Block.io PIN</label>
            <input type="text" name="blockio_pin" id="blockio_pin" placeholder="Block.io secret pin" class="form-control @error('blockio_pin') is-invalid @enderror"
                   value="{{ setting_field('blockio_pin') }}">
            <small class="form-text">Block.io Secret Pin</small>
            @error('blockio_pin')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="blockio_api">Block.io API Key</label>
            <input type="text" name="blockio_api" id="blockio_api" placeholder="Block.io api key" class="form-control @error('blockio_api') is-invalid @enderror"
                   value="{{ setting_field('blockio_api') }}">
            <small class="form-text">Block.io api key(live mode)</small>
            @error('blockio_api')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="blockio_testapi">Block.io API Key(Testnet)</label>
            <input type="text" name="blockio_testapi" id="blockio_testapi" placeholder="Block.io api test key"
                   class="form-control @error('blockio_testapi') is-invalid @enderror" value="{{ setting_field('blockio_testapi') }}">
            <small class="form-text">Block.io api key for testnet(test mode)</small>
            @error('blockio_testapi')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>