<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="deposit_gateway">Deposit Method</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-piggy-bank"></i></div>
                </div>
                <select name="deposit_gateway" id="deposit_gateway" class="form-control @error('deposit_gateway') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    <option value="coinpayments" @if(setting('deposit_gateway') === 'coinpayments')selected @endif>Coinpayments</option>
                    <option value="paykassa" @if(setting('deposit_gateway') === 'paykassa')selected @endif>PayKassa</option>
                    <option value="coingate" @if(setting('deposit_gateway') === 'coingate')selected @endif>CoinGate</option>
                    <option value="gourl" @if(setting('deposit_gateway') === 'gourl')selected @endif>GoUrl</option>
                    <option value="cryptapi" @if(setting('deposit_gateway') === 'cryptapi')selected @endif>CryptAPI</option>
                    <option value="sendbit" @if(setting('deposit_gateway') === 'sendbit')selected @endif>SendBit</option>
                    <option value="faucetpay" @if(setting('deposit_gateway') === 'faucetpay')selected @endif>FaucetPay</option>
                    <option value="hspay" @if(setting('deposit_gateway') === 'hspay')selected @endif>HSPay</option>
                </select>
                @error('deposit_gateway')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Deposit Method to use on site.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_gateway">Withdrawal Method</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-hand-holding-usd"></i></div>
                </div>
                <select name="withdrawal_gateway" id="withdrawal_gateway" class="form-control @error('withdrawal_gateway') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    <option value="hspay" @if(setting('withdrawal_gateway') === 'hspay')selected @endif>HSPay</option>
                </select>
                @error('withdrawal_gateway')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Withdrawal Method to use on site.</small>
        </div>
    </div>
    <div class="col-12">
        <h5>Currency Codes</h5>
        <p>You must use the currency code, according to the API that is used. Normally, in the list of supported currencies you will find the correct code to use.</p>
        <p><strong>Examples</strong>: in Coinpayments, use LTC(for Litecoin), SHIB.BEP20(for Shiba on BSC network), etc.</p>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="deposit_currency_code">Currency Code(Deposits)</label>
            <input type="text" name="deposit_currency_code" id="deposit_currency_code" placeholder="Currency Code(Deposits)"
                   class="form-control @error('deposit_currency_code') is-invalid @enderror"
                   value="{{ setting('deposit_currency_code', setting('currency_code', 'LTC')) }}">
            @error('deposit_currency_code')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
            <small class="form-text">Currency code used to receive payments.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_currency_code">Currency Code(Withdraws)</label>
            <input type="text" name="withdrawal_currency_code" id="withdrawal_currency_code" placeholder="Currency Code(Withdraws)"
                   class="form-control @error('withdrawal_currency_code') is-invalid @enderror"
                   value="{{ setting('withdrawal_currency_code', setting('currency_code', 'LTC')) }}">
            @error('withdrawal_currency_code')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
            <small class="form-text">Currency code used to make payments.</small>
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="whitelist_ip">Whitelist IP</label>
            <input type="text" id="whitelist_ip" placeholder="Whitelist IP"
                   class="form-control" readonly
                   value="{{ request()->server('SERVER_ADDR') }}">
            <small class="form-text">Use this ip to restrict API access to ensure greater security (when available).</small>
        </div>
    </div>
</div>
<hr>
<h4>Gateways Settings</h4>
<div class="row mb-2">
    <div class="col-lg-2 col-sm-12">
        <!-- Nav tabs -->
        <div class="nav flex-column nav-tabs h-100" id="vert-tabs-tab" role="tablist" aria-orientation="vertical">
            <a class="nav-link active" id="coinpayments-tab" data-toggle="pill" href="#coinpayments" role="tab" aria-controls="coinpayments" aria-selected="true">Coinpayments</a>
            <a class="nav-link" id="blockio-tab" data-toggle="pill" href="#blockio" role="tab" aria-controls="blockio" aria-selected="false">Block.io</a>
            <a class="nav-link" id="paykassa-tab" data-toggle="pill" href="#paykassa" role="tab" aria-controls="paykassa" aria-selected="false">PayKassa</a>
            <a class="nav-link" id="coingate-tab" data-toggle="pill" href="#coingate" role="tab" aria-controls="coingate" aria-selected="false">CoinGate</a>
            <a class="nav-link" id="gourl-tab" data-toggle="pill" href="#gourl" role="tab" aria-controls="gourl" aria-selected="false">GoURL</a>
            <a class="nav-link" id="faucetpay-tab" data-toggle="pill" href="#faucetpay" role="tab" aria-controls="faucetpay" aria-selected="false">FaucetPay</a>
            <a class="nav-link" id="cryptapi-tab" data-toggle="pill" href="#cryptapi" role="tab" aria-controls="cryptapi" aria-selected="false">CryptAPI</a>
            <a class="nav-link" id="sendbit-tab" data-toggle="pill" href="#sendbit" role="tab" aria-controls="sendbit" aria-selected="false">SendBit</a>
            <a class="nav-link" id="hspay-tab" data-toggle="pill" href="#hspay" role="tab" aria-controls="hspay" aria-selected="false">HSPay</a>
        </div>
    </div>
    <div class="col-lg-10 col-sm-12">
        <div class="tab-content mt-2">
            <div class="tab-pane text-left fade show active" id="coinpayments" role="tabpanel" aria-labelledby="coinpayments-tab">
                @include('admin.settings.gateways.coinpayments')
            </div>
            <div class="tab-pane fade" id="blockio" role="tabpanel" aria-labelledby="blockio-tab">
                @include('admin.settings.gateways.blockio')
            </div>
            <div class="tab-pane fade" id="paykassa" role="tabpanel" aria-labelledby="paykassa-tab">
                @include('admin.settings.gateways.paykassa')
            </div>
            <div class="tab-pane fade" id="coingate" role="tabpanel" aria-labelledby="coingate-tab">
                @include('admin.settings.gateways.coingate')
            </div>
            <div class="tab-pane fade" id="gourl" role="tabpanel" aria-labelledby="gourl-tab">
                @include('admin.settings.gateways.gourl')
            </div>
            <div class="tab-pane fade" id="faucetpay" role="tabpanel" aria-labelledby="faucetpay-tab">
                @include('admin.settings.gateways.faucetpay')
            </div>
            <div class="tab-pane fade" id="cryptapi" role="tabpanel" aria-labelledby="cryptapi-tab">
                @include('admin.settings.gateways.cryptapi')
            </div>
            <div class="tab-pane fade" id="sendbit" role="tabpanel" aria-labelledby="sendbit-tab">
                @include('admin.settings.gateways.sendbit')
            </div>
            <div class="tab-pane fade" id="hspay" role="tabpanel" aria-labelledby="hspay-tab">
                @include('admin.settings.gateways.hspay')
            </div>
        </div>
    </div>
</div>