<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="admin_pagination">Admin Pagination</label>
            <input type="number" step="1" min="1" class="form-control @error('admin_pagination') is-invalid @enderror" id="admin_pagination" name="admin_pagination" value="{{ setting('admin_pagination') }}" placeholder="Admin Pagination">
            @error('admin_pagination')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="site_pagination">Site Pagination</label>
            <input type="number" step="1" min="1" class="form-control @error('site_pagination') is-invalid @enderror" id="site_pagination" name="site_pagination" value="{{ setting('site_pagination') }}" placeholder="Site Pagination">
            @error('site_pagination')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="default_editor">Default Text Editor</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-font"></i></div>
                </div>
                <select name="default_editor" id="default_editor" class="form-control @error('default_editor') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    <option value="summernote" @if(setting('default_editor') === 'summernote')selected @endif>Summernote</option>
                    <option value="tinymce" @if(setting('default_editor') === 'tinymce')selected @endif>TinyMCE</option>
                </select>
                @error('default_editor')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="default_alerts">Default Alerts</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-exclamation-triangle"></i></div>
                </div>
                <select name="default_alerts" id="default_alerts" class="form-control @error('default_alerts') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    <option value="alerts" @if(setting('default_alerts') === 'alerts')selected @endif>Bootstrap Alerts</option>
                    <option value="toastr" @if(setting('default_alerts') === 'toastr')selected @endif>Toastr</option>
                    <option value="sweetalert" @if(setting('default_alerts') === 'sweetalert')selected @endif>SweetAlert2</option>
                </select>
                @error('default_alerts')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text text-muted">Success and error flash messages</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="frontend_theme">Active Theme (Site)</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-palette"></i></div>
                </div>
                <select name="frontend_theme" id="frontend_theme" class="form-control @error('frontend_theme') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    @foreach (theme_detect() as $theme)
                        <option value="{{ $theme }}" @if(setting('frontend_theme') === $theme)selected @endif>{{ $theme }}</option>
                    @endforeach
                </select>
                @error('frontend_theme')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text text-muted">Active theme</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="dashboard_theme">Active Theme (Dashboard)</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-palette"></i></div>
                </div>
                <select name="dashboard_theme" id="dashboard_theme" class="form-control @error('dashboard_theme') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    @foreach (theme_detect('dashboard') as $theme)
                        <option value="{{ $theme }}" @if(setting('dashboard_theme') === $theme)selected @endif>{{ $theme }}</option>
                    @endforeach
                </select>
                @error('dashboard_theme')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text text-muted">Active theme</small>
        </div>
    </div>
</div>
<h4>Statistics</h4>
<div class="row">
    <div class="col-lg-2 col-sm-12">
        <div class="form-group">
            <label for="frontend_statistics">Show Statistics(Frontend)</label>
            <select name="frontend_statistics" id="frontend_statistics" class="form-control @error('frontend_statistics') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="1" @if(setting('frontend_statistics') === '1')selected @endif>Yes</option>
                <option value="0" @if(setting('frontend_statistics') === '0')selected @endif>No</option>
            </select>
            <small class="form-text text-muted">Show/Hide Statistics on Home Page</small>
            @error('frontend_statistics')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-2 col-sm-12">
        <div class="form-group">
            <label for="fake_users">Additional Users</label>
            <input type="number" step="1" min="0" class="form-control @error('fake_users') is-invalid @enderror" id="fake_users" name="fake_users" value="{{ setting('fake_users') }}" placeholder="Additional Users">
            <small class="form-text text-muted">Add more users to the count. Leave blank to use real data</small>
            @error('fake_users')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-2 col-sm-12">
        <div class="form-group">
            <label for="fake_days">Additional Days</label>
            <input type="number" step="1" min="0" class="form-control @error('fake_days') is-invalid @enderror" id="fake_days" name="fake_days" value="{{ setting('fake_days') }}" placeholder="Additional Days">
            <small class="form-text text-muted">Add more days to the count. Leave blank to use real data</small>
            @error('fake_days')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="fake_deposits">Total Deposits</label>
            <input type="number" step="0.00000001" class="form-control @error('fake_deposits') is-invalid @enderror" id="fake_deposits" name="fake_deposits" value="{{ setting('fake_deposits') }}" placeholder="Total Deposits">
            <small class="form-text text-muted">Increases the total amount deposited. Leave blank to use real data</small>
            @error('fake_deposits')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="fake_withdrawals">Total Paid</label>
            <input type="number" step="0.00000001" class="form-control @error('fake_withdrawals') is-invalid @enderror" id="fake_withdrawals" name="fake_withdrawals" value="{{ setting('fake_withdrawals') }}" placeholder="Total Paid">
            <small class="form-text text-muted">Increases the total amount paid. Leave blank to use real data</small>
            @error('fake_withdrawals')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>

    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="frontend_latest_transactions">Show Latest Transactions</label>
            <select name="frontend_latest_transactions" id="frontend_latest_transactions" class="form-control @error('frontend_latest_transactions') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="1" @if(setting('frontend_latest_transactions') === '1' || old('frontend_latest_transactions') == '1')selected @endif>Yes</option>
                <option value="0" @if(setting('frontend_latest_transactions') === '0' || old('frontend_latest_transactions', 0) == '0')selected @endif>No</option>
            </select>
            <small class="form-text text-muted">Show/Hide the latest Deposits and Withdrawals on Home Page</small>
            @error('frontend_latest_transactions')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="frontend_latest_transactions_txid">Show TXID</label>
            <select name="frontend_latest_transactions_txid" id="frontend_latest_transactions_txid" class="form-control @error('frontend_latest_transactions_txid') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="1" @if(setting('frontend_latest_transactions_txid') === '1' || old('frontend_latest_transactions_txid') == '1')selected @endif>Yes</option>
                <option value="0" @if(setting('frontend_latest_transactions_txid') === '0' || old('frontend_latest_transactions_txid', 0) == '0')selected @endif>No</option>
            </select>
            <small class="form-text text-muted">Show/Hide TXID column</small>
            @error('frontend_latest_transactions_txid')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="frontend_latest_deposits">Deposit Records</label>
            <input type="number" step="1" min="5" class="form-control @error('frontend_latest_deposits') is-invalid @enderror" id="frontend_latest_deposits" name="frontend_latest_deposits" value="{{ setting('frontend_latest_deposits') }}" placeholder="Deposit Records">
            <small class="form-text text-muted">How many deposits should be displayed</small>
            @error('frontend_latest_deposits')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="frontend_latest_withdrawals">Withdrawal Records</label>
            <input type="number" step="1" min="5" class="form-control @error('frontend_latest_withdrawals') is-invalid @enderror" id="frontend_latest_withdrawals" name="frontend_latest_withdrawals" value="{{ setting('frontend_latest_withdrawals') }}" placeholder="Withdrawal Records">
            <small class="form-text text-muted">How many withdrawals should be displayed</small>
            @error('frontend_latest_withdrawals')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
<h4>Custom Codes</h4>
<div class="form-group">
    <label for="dashboard_theme">Custom CSS (Site)</label>
    <textarea name="custom_css_site" id="custom_css_site" class="form-control" rows="10">{{ setting('custom_css_site') }}</textarea>
    <small class="form-text text-muted">Custom CSS classes for site</small>
</div>
<div class="form-group">
    <label for="dashboard_theme">Custom CSS (Dashboard)</label>
    <textarea name="custom_css_dashboard" id="custom_css_dashboard" class="form-control" rows="10">{{ setting('custom_css_dashboard') }}</textarea>
    <small class="form-text text-muted">Custom CSS classes for dashboard</small>
</div>