<div class="row">
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="rates_api">Exchange Rates API</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-dollar-sign"></i></div>
                </div>
                <select name="rates_api" id="rates_api" class="form-control @error('rates_api') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    <option value="coingecko" @if(setting('rates_api') === 'coingecko')selected @endif>CoinGecko</option>
                    <option value="cryptonator" @if(setting('rates_api') === 'cryptonator')selected @endif>Cryptonator</option>
                </select>
                @error('rates_api')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">API to be used to consult the exchange rate.</small>
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="rates_api_crypto_currency">Currency Code/ID</label>
            <input type="text" class="form-control @error('rates_api_crypto_currency') is-invalid @enderror" id="rates_api_crypto_currency" name="rates_api_crypto_currency" value="{{ setting('rates_api_crypto_currency') }}" placeholder="Currency Code" >
            <small class="form-text"><a href="https://api.coingecko.com/api/v3/coins/list" target="_blank">For CoinGecko</a>, use id. <a href="https://www.cryptonator.com/api/currencies" target="_blank">For Cryptonator</a> use code.</small>
            @error('rates_api_crypto_currency')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="rates_api_currency">Fiat Currency</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-dollar-sign"></i></div>
                </div>
                <select name="rates_api_currency" id="rates_api_currency" class="form-control @error('rates_api_currency') is-invalid @enderror">
                    <option value="">-- Select an option --</option>
                    @foreach (fiat_currencies() as $currency)
                        <option value="{{ $currency->id }}" @if(setting('rates_api_currency') === $currency->id)selected @endif>{{ $currency->id }} - {{ $currency->name }}</option>
                    @endforeach
                </select>
                @error('rates_api_currency')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Currency to be used for exchange rate.</small>
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="rates_api_interval">Exchange Rates Update Interval</label>
            <div class="input-group">
                <input type="number" step="1" min="1" class="form-control @error('rates_api_interval') is-invalid @enderror" id="rates_api_interval" name="rates_api_interval" value="{{ setting('rates_api_interval') }}" placeholder="Exchange Rates Update Interval">
                <div class="input-group-append">
                    <div class="input-group-text">minutes</div>
                </div>
                @error('rates_api_interval')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Interval for updating the current exchange rate(in minutes).</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="auto_suspend_users_interval">Auto Suspend Inactive Users</label>
            <div class="input-group">
                <input type="number" step="1" min="0" class="form-control @error('auto_suspend_users_interval') is-invalid @enderror" id="auto_suspend_users_interval" name="auto_suspend_users_interval" value="{{ setting('auto_suspend_users_interval') }}" placeholder="Auto Suspend Inactive Users">
                <div class="input-group-append">
                    <div class="input-group-text">hours</div>
                </div>
                @error('auto_suspend_users_interval')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Automatically suspends inactive accounts that have not made deposits. Leave 0(zero) to disable. <strong>Requires
                    <a href="#cronjobs">Cron Jobs</a></strong>.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="reinvest_status">Reinvest Option</label>
            <select name="reinvest_status" id="reinvest_status" class="form-control @error('reinvest_status') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="enabled" @if(setting('reinvest_status') === 'enabled')selected @endif>Enabled</option>
                <option value="disabled" @if(setting('reinvest_status') === 'disabled')selected @endif>Disabled</option>
            </select>
            <small class="form-text">Enables/disables the option to convert the balance into mining power.</small>
            @error('reinvest_status')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="signup_bonus">Sign up Bonus</label>
            <div class="input-group">
                <input type="number" step="1" min="0" class="form-control @error('signup_bonus') is-invalid @enderror" id="signup_bonus" name="signup_bonus" value="{{ setting('signup_bonus') }}" placeholder="Hashpower Sign up Bonus">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('hashpower_unit') }}/s</div>
                </div>
                @error('signup_bonus')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Bonus mining power after registration. Leave 0(zero) to disable</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="referral_bonus">Referral Bonus</label>
            <div class="input-group">
                <input type="number" step="1" min="0" class="form-control @error('referral_bonus') is-invalid @enderror" id="referral_bonus" name="referral_bonus" value="{{ setting('referral_bonus') }}" placeholder="Referral Bonus">
                <div class="input-group-append">
                    <div class="input-group-text">%</div>
                </div>
                @error('referral_bonus')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Bonus percentage for each deposit made by the referral</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="purchase_min">Min Mining Power Purchase</label>
            <div class="input-group">
                <input type="number" step="1" min="1" class="form-control @error('purchase_min') is-invalid @enderror" id="purchase_min" name="purchase_min" value="{{ setting('purchase_min') }}" placeholder="Min Mining Power Purchase">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('hashpower_unit') }}/s</div>
                </div>
                @error('purchase_min')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Min purchase of mining power</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="start_date">Start Date</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                </div>
                <input type="text" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ setting('start_date') }}" placeholder="Start Date">
                @error('start_date')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Format: Year-Month-Day Hour:Minute:Seconds (Now: {{ date('Y-m-d H:i:s') }})</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="blockchain_url">Transaction Explorer URL</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text"><i class="fa fa-link"></i></div>
                </div>
                <input type="url" class="form-control @error('blockchain_url') is-invalid @enderror" id="blockchain_url" name="blockchain_url" value="{{ setting('blockchain_url') }}" placeholder="Transaction Explorer URL">
                @error('blockchain_url')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Url to view transactions on blockchain. Eg: https://chain.so/tx/DOGE/</small>
        </div>
    </div>
</div>
<h4>Hashpower</h4>
<div class="alert alert-danger">Pay attention to the minimum deposit amount of the Gateway you are going to use, or users will not be able to purchase small amounts of hashpower. If the price of each unit of hashpower is below the minimum deposit amount, you must use the "Min Mining Power Purchase" field to set a minimum purchase quantity.</div>
<div class="row">
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="hashpower_price">Hashpower Price</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text">1 {{ setting('hashpower_unit') }}/s =</div>
                </div>
                <input type="number" step="0.00000001" class="form-control @error('hashpower_price') is-invalid @enderror" id="hashpower_price" name="hashpower_price" value="{{ setting('hashpower_price') }}" placeholder="Hashpower Price">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('currency_code') }}</div>
                </div>
                @error('hashpower_price')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">How much does each unit of mining power cost.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="daily_profit">Daily Profit</label>
            <div class="input-group">
                <div class="input-group-append">
                    <div class="input-group-text">1 {{ setting('hashpower_unit') }}/s =</div>
                </div>
                <input type="number" step="0.00000001" class="form-control @error('daily_profit') is-invalid @enderror" id="daily_profit" name="daily_profit" value="{{ setting('daily_profit') }}" placeholder="Daily Profit">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('currency_code') }}/ day</div>
                </div>
                @error('daily_profit')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Daily Profit per Hashpower.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="hashpower_unit">Hashpower Unit</label>
            <select name="hashpower_unit" id="hashpower_unit" class="form-control @error('hashpower_unit') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="H" @if(setting('hashpower_unit') === 'H')selected @endif>H(hashes)</option>
                <option value="KH" @if(setting('hashpower_unit') === 'KH')selected @endif>KH(kilo hashes)</option>
                <option value="MH" @if(setting('hashpower_unit') === 'MH')selected @endif>MH(mega hashes)</option>
                <option value="GH" @if(setting('hashpower_unit') === 'GH')selected @endif>GH(giga hashes)</option>
                <option value="TH" @if(setting('hashpower_unit') === 'TH')selected @endif>TH(tera hashes)</option>
            </select>
            <small class="form-text">Unit of measure of mining power. Ex: H, KH, MH, GH, TH</small>
            @error('hashpower_unit')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="period">Duration of Mining Power</label>
            <div class="input-group">
                <input type="number" step="1" min="1" class="form-control @error('period') is-invalid @enderror" id="period" name="period" value="{{ setting('period') }}" placeholder="Duration of Mining Power">
                <div class="input-group-append">
                    <div class="input-group-text">days</div>
                </div>
                @error('period')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">How many days does the Mining Power last after purchase.</small>
        </div>
    </div>
    <div class="col-lg-12 col-sm-12">
        <div class="form-group">
            <label for="calculator_periods">Profit Calculator Periods</label>
            <div class="input-group">
                <input type="text" class="form-control tagin @error('calculator_periods') is-invalid @enderror" id="calculator_periods" name="calculator_periods" value="{{ setting('calculator_periods') }}" data-placeholder="Add a number of days then press comma">
                <div class="input-group-append">
                    <div class="input-group-text">days</div>
                </div>
                @error('calculator_periods')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Ranges of days to use in the calculator(separated by comma). Eg: 1, 30, 60, 90, 180, 360</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="mining_counter_seconds">Mining Counter Seconds</label>
            <div class="input-group">
                <input type="number" step="1" min="1" class="form-control @error('mining_counter_seconds') is-invalid @enderror" id="mining_counter_seconds" name="mining_counter_seconds" value="{{ setting('mining_counter_seconds', 86400) }}" placeholder="Mining Counter Seconds">
                <div class="input-group-append">
                    <div class="input-group-text">seconds</div>
                </div>
                @error('mining_counter_seconds')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">A day is 86400 seconds, adjust if necessary to compensate for counter speed.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="mining_counter_speed">Mining Counter Speed</label>
            <div class="input-group">
                <input type="number" step="1" min="1" class="form-control @error('mining_counter_speed') is-invalid @enderror" id="mining_counter_speed" name="mining_counter_speed" value="{{ setting('mining_counter_speed', 1000) }}" placeholder="Mining Counter Speed">
                <div class="input-group-append">
                    <div class="input-group-text">milliseconds</div>
                </div>
                @error('mining_counter_speed')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Counter update time in milliseconds.</small>
        </div>
    </div>
</div>
<h4>Currency</h4>
<div class="row">
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="currency_name">Currency Name</label>
            <input type="text" class="form-control @error('currency_name') is-invalid @enderror" id="currency_name" name="currency_name" value="{{ setting('currency_name') }}" placeholder="Currency Name">
            <small class="form-text">Dogecoin, Bitcoin, Litecoin, Ethereum, etc</small>
            @error('currency_name')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="currency_code">Currency Code</label>
            <input type="text" class="form-control @error('currency_code') is-invalid @enderror" id="currency_code" name="currency_code" value="{{ setting('currency_code') }}" placeholder="Currency Code" onkeyup="this.value = this.value.toUpperCase();">
            <small class="form-text">DOGE, BTC, LTC, ETH, etc</small>
            @error('currency_code')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="currency_decimals">Currency Decimals</label>
            <input type="number" step="1" min="0" class="form-control @error('currency_decimals') is-invalid @enderror" id="currency_decimals" name="currency_decimals" value="{{ setting('currency_decimals') }}" placeholder="Currency Decimals">
            <small class="form-text">0 decimals: 10. 2 decimals: 10.00. 4 decimals: 10.0000</small>
            @error('currency_decimals')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="balance_decimals">Currency Decimals(crypto balance)</label>
            <input type="number" step="1" min="0" class="form-control @error('balance_decimals') is-invalid @enderror" id="balance_decimals" name="balance_decimals" value="{{ setting('balance_decimals') }}" placeholder="Currency Decimals(crypto balance)">
            <small class="form-text">0 decimals: 10. 2 decimals: 10.00. 4 decimals: 10.0000</small>
            @error('balance_decimals')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-4 col-sm-12">
        <div class="form-group">
            <label for="fiat_balance_decimals">Currency Decimals(fiat balance)</label>
            <input type="number" step="1" min="0" class="form-control @error('fiat_balance_decimals') is-invalid @enderror" id="fiat_balance_decimals" name="fiat_balance_decimals" value="{{ setting('fiat_balance_decimals') }}" placeholder="Currency Decimals(fiat balance)">
            <small class="form-text">0 decimals: 10. 2 decimals: 10.00. 4 decimals: 10.0000</small>
            @error('fiat_balance_decimals')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>
<h4>Withdrawal Settings</h4>
<p>Configure how you want payments to be made.</p>
<ul>
    <li><strong>Auto(instant)</strong>: use if you want payments to be instantaneous.</li>
    <li><strong>Auto(Cron Jobs)</strong>: use if you want payments to be made every time interval. Example: every 5 minutes, every hour, once a day, etc. Create a Cron Jobs task with the below command to run as often as you like. If the command doesn't work, follow the instructions on your server's CronJobs page, or ask your hosting technical support for help.</li>
    <li><strong>Manual</strong>: Use if you want to manually pay for each withdrawal request.</li>
</ul>
<div class="row">
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_method">Withdrawal Mode</label>
            <select name="withdrawal_method" id="withdrawal_method" class="form-control @error('withdrawal_method') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="auto" @if(setting('withdrawal_method') === 'auto')selected @endif>Auto(instant)</option>
                <option value="cron" @if(setting('withdrawal_method') === 'cron')selected @endif>Auto(Cron Jobs)</option>
                <option value="manual" @if(setting('withdrawal_method') === 'manual')selected @endif>Manual</option>
            </select>
            @error('withdrawal_method')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-3 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_deposit_required">Required Deposit Before Withdrawal</label>
            <select name="withdrawal_deposit_required" id="withdrawal_deposit_required" class="form-control @error('withdrawal_deposit_required') is-invalid @enderror">
                <option value="">-- Select an option --</option>
                <option value="yes" @if(setting('withdrawal_deposit_required') === 'yes')selected @endif>Yes</option>
                <option value="no" @if(setting('withdrawal_deposit_required') === 'no')selected @endif>No</option>
            </select>
            <small class="form-text">Requires a deposit to enable requesting a withdrawal</small>
            @error('withdrawal_deposit_required')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="cronjobs">Cron Jobs Command </label>
            <div class="input-group">
                <div class="input-group-append" title="Copy to Clipboard" onclick="copyCronJobs();">
                    <div class="input-group-text"><i class="fa fa-copy"></i></div>
                </div>
                <input type="text" readonly="" id="cronjobs" class="form-control" value="/usr/local/bin/php {{ base_path('') }}/artisan schedule:run >> /dev/null 2>&amp;1">
            </div>
            <small class="form-text text-success" style="display: none" id="cron_jobs_copied">Copied to Clipboard</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_min">Min Withdrawal Amount</label>
            <div class="input-group">
                <input type="number" step="0.00000001" class="form-control @error('withdrawal_min') is-invalid @enderror" id="withdrawal_min" name="withdrawal_min" value="{{ setting('withdrawal_min', 1) }}" placeholder="Min Withdrawal Amount">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('currency_code') }}</div>
                </div>
                @error('withdrawal_min')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Min withdrawal amount</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_max_auto">Max Withdrawal Amount (auto/cron mode)</label>
            <div class="input-group">
                <input type="number" step="0.00000001" class="form-control @error('withdrawal_max_auto') is-invalid @enderror" id="withdrawal_max_auto" name="withdrawal_max_auto" value="{{ setting('withdrawal_max_auto', 100) }}" placeholder="Max Withdrawal Amount">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('currency_code') }}</div>
                </div>
                @error('withdrawal_max_auto')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Max withdrawal amount for automatic mode.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_fee_fixed">Withdrawal Fee (fixed)</label>
            <div class="input-group">
                <input type="number" step="0.00000001" class="form-control @error('withdrawal_fee_fixed') is-invalid @enderror" id="withdrawal_fee_fixed" name="withdrawal_fee_fixed" value="{{ setting('withdrawal_fee_fixed', 0) }}" placeholder="Withdrawal Fee Amount">
                <div class="input-group-append">
                    <div class="input-group-text">{{ setting('currency_code') }}</div>
                </div>
                @error('withdrawal_fee_fixed')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Withdrawal fee (fixed amount). Calc: Amount - Percentage Rate - Fixed Rate = Amount Received.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_fee_percent">Withdrawal Fee (percent)</label>
            <div class="input-group">
                <input type="number" step="1" min="0" max="100" class="form-control @error('withdrawal_fee_percent') is-invalid @enderror" id="withdrawal_fee_percent" name="withdrawal_fee_percent" value="{{ setting('withdrawal_fee_percent', 0) }}" placeholder="Withdrawal Fee Percent">
                <div class="input-group-append">
                    <div class="input-group-text">%</div>
                </div>
                @error('withdrawal_fee_percent')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
                @enderror
            </div>
            <small class="form-text">Withdrawal fee (percent). Calc: Amount - Percentage Rate - Fixed Rate = Amount Received.</small>
        </div>
    </div>
    <div class="col-lg-6 col-sm-12">
        <div class="form-group">
            <label for="withdrawal_max_daily">Max Daily Withdrawal Requests</label>
            <input type="number" step="1" min="0" class="form-control @error('withdrawal_max_daily') is-invalid @enderror" id="withdrawal_max_daily" name="withdrawal_max_daily" value="{{ setting('withdrawal_max_daily') }}" placeholder="Max Daily Withdrawal Requests">
            <small class="form-text">Max Daily Withdrawal Requests. Leave 0(zero) to unlimited.</small>
            @error('withdrawal_max_daily')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
            @enderror
        </div>
    </div>
</div>

@push('additional_styles')
    <!--Input tags-->
    <link rel="stylesheet" href="https://rawcdn.githack.com/darkterminal/tagin/6fa2863c13aa1841f33cf6dcbbf266c92fbf5412/dist/css/tagin.min.css">
@endpush
@push('additional_scripts')
    <!--Input tags-->
    <script src="https://rawcdn.githack.com/darkterminal/tagin/6fa2863c13aa1841f33cf6dcbbf266c92fbf5412/dist/js/tagin.min.js"></script>
    <script>
        tagin( document.querySelector('.tagin') );
        function copyCronJobs(){
            document.getElementById('cronjobs').select();
            document.execCommand('copy');
            document.getElementById('cron_jobs_copied').style.display='block';
            const copied = $('#cron_jobs_copied');
            setTimeout(function(){
                copied.fadeOut(1500);
            }, 3000);
        }
    </script>
@endpush