@extends('layouts.admin.default')

@section('content')
    @include('admin.partials.alerts')
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Roles List</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.roles.create') }}" class="btn btn-sm btn-success @cannot('create-roles')disabled @endcannot"><i class="fa fa-plus-square"></i> Create</a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Name</th>
                                <th scope="col">Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($items as $item)
                                <tr>
                                    <th scope="row">{{ $item->id }}</th>
                                    <td>{{ $item->name }}</td>
                                    <td>
                                        <form action="{{ route('admin.roles.destroy', $item->id) }}" method="post" onsubmit="return confirm('Are you sure you want to delete this record?')">
                                            @csrf
                                            @method('delete')
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.roles.edit', $item->id) }}" class="btn btn-info @cannot('show-roles')disabled @endcannot"><i class="fa fa-edit"></i> Edit</a>
                                                <button type="submit" class="btn btn-danger" @cannot('delete-roles')disabled="disabled" @endcannot><i class="fa fa-trash"></i> Delete</button>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center">No results found!</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $items->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
